/*
 * Decompiled with CFR 0.152.
 */
package chat.octet.model.beans;

import com.fasterxml.jackson.annotation.JsonInclude;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ChatMessage {
    private ChatRole role;
    private String content;

    public ChatMessage() {
    }

    public ChatMessage(ChatRole role, String content) {
        this.role = role;
        this.content = content;
    }

    public static ChatMessage toSystem(String content) {
        return new ChatMessage(ChatRole.SYSTEM, content);
    }

    public static ChatMessage toUser(String content) {
        return new ChatMessage(ChatRole.USER, content);
    }

    public static ChatMessage toAssistant(String content) {
        return new ChatMessage(ChatRole.ASSISTANT, content);
    }

    public ChatRole getRole() {
        return this.role;
    }

    public String getContent() {
        return this.content;
    }

    public void setRole(ChatRole role) {
        this.role = role;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatMessage)) {
            return false;
        }
        ChatMessage other = (ChatMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ChatRole this$role = this.getRole();
        ChatRole other$role = other.getRole();
        if (this$role == null ? other$role != null : !((Object)((Object)this$role)).equals((Object)other$role)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        return !(this$content == null ? other$content != null : !this$content.equals(other$content));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChatMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ChatRole $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : ((Object)((Object)$role)).hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        return result;
    }

    public String toString() {
        return "ChatMessage(role=" + (Object)((Object)this.getRole()) + ", content=" + this.getContent() + ")";
    }

    public static enum ChatRole {
        SYSTEM,
        USER,
        ASSISTANT;

    }
}

