/*
 * Decompiled with CFR 0.152.
 */
package chat.octet.model.utils;

import chat.octet.model.enums.ModelType;
import org.apache.commons.lang3.StringUtils;

public class PromptBuilder {
    public static final String DEFAULT_ALPACA_SYSTEM = "Below is an instruction that describes a task. Write a response that appropriately completes the request.";
    public static final String DEFAULT_COMMON_SYSTEM = "You are a helpful, respectful and honest assistant. Always answer as helpfully as possible, while being safe.  Your answers should not include any harmful, unethical, racist, sexist, toxic, dangerous, or illegal content. Please ensure that your responses are socially unbiased and positive in nature.\nIf a question does not make any sense, or is not factually coherent, explain why instead of answering something not correct. If you don't know the answer to a question, please don't share false information.";

    public static String toPrompt(ModelType modelType, String question) {
        return PromptBuilder.toPrompt(modelType, null, question);
    }

    public static String toPrompt(ModelType modelType, String system, String question) {
        switch (modelType) {
            case ALPACA: {
                String formatSystem = StringUtils.isBlank((CharSequence)system) ? "\n\n" : StringUtils.join((Object[])new String[]{system, "\n\n"});
                return StringUtils.join((Object[])new String[]{formatSystem, "### Instruction:\n", question, "\n\n### Response:\n"});
            }
            case SNOOZY: {
                String formatSystem = StringUtils.isBlank((CharSequence)system) ? "\n" : StringUtils.join((Object[])new String[]{"### Instruction:\n", system, "\n\n"});
                return StringUtils.join((Object[])new String[]{formatSystem, "### Prompt\n", question, "\n### Response\n"});
            }
            case VICUNA: {
                String formatSystem = StringUtils.isBlank((CharSequence)system) ? "\n\n" : StringUtils.join((Object[])new String[]{system, "\n\n"});
                return StringUtils.join((Object[])new String[]{formatSystem, "USER:\n", question, "\n\nASSISTANT:\n"});
            }
            case OASST_LLAMA: {
                String formatSystem = StringUtils.isBlank((CharSequence)system) ? "\n\n" : StringUtils.join((Object[])new String[]{"[INST] <<SYS>>\n", system, "\n<</SYS>>\n\n"});
                return StringUtils.join((Object[])new String[]{formatSystem, "<|prompter|>\n", question, "\n\n<|assistant|>\n"});
            }
            case REDPAJAMA_INCITE: {
                String formatSystem = StringUtils.isBlank((CharSequence)system) ? "\n" : StringUtils.join((Object[])new String[]{system, "\n\n"});
                return StringUtils.join((Object[])new String[]{formatSystem, "<human>\n", question, "\n<bot>\n"});
            }
            case LLAMA2: {
                String formatSystem = StringUtils.isBlank((CharSequence)system) ? "" : StringUtils.join((Object[])new String[]{"<<SYS>>\n", system, "\n<</SYS>>\n\n"});
                return StringUtils.join((Object[])new String[]{"[INST] ", formatSystem, question, " [/INST] "});
            }
        }
        String formatSystem = StringUtils.isBlank((CharSequence)system) ? "\n" : StringUtils.join((Object[])new String[]{system, "\n\n"});
        return StringUtils.join((Object[])new String[]{formatSystem, "User: ", question, "\nAssistant: "});
    }
}

