/*
 * Decompiled with CFR 0.152.
 */
package chat.octet.model;

import chat.octet.model.LlamaService;
import java.nio.charset.StandardCharsets;

public class TokenDecoder {
    private TokenDecoder() {
    }

    public static String decodeToken(int ... tokens) {
        byte[] buffer = new byte[tokens.length * 64];
        int length = 0;
        for (int token : tokens) {
            byte[] bytes = new byte[64];
            int size = LlamaService.tokenToPiece(token, bytes, bytes.length);
            System.arraycopy(bytes, 0, buffer, length, size);
            length += size;
        }
        return new String(buffer, 0, length, StandardCharsets.UTF_8);
    }

    public static int isMultiByte(int token) {
        byte[] buffer = new byte[64];
        int size = LlamaService.tokenToPiece(token, buffer, buffer.length);
        byte code = buffer[0];
        if (size == 1 && !Character.isValidCodePoint(code)) {
            try {
                return TokenDecoder.getUtf8ByteLength(code);
            }
            catch (Exception e) {
                return -1;
            }
        }
        return 0;
    }

    public static int getUtf8ByteLength(byte bytes) {
        int topBits = bytes & 0xFF;
        if (topBits <= 127) {
            return 1;
        }
        if (topBits >= 194 && topBits <= 223) {
            return 2;
        }
        if (topBits >= 224 && topBits <= 239) {
            return 3;
        }
        if (topBits >= 240 && topBits <= 247) {
            return 4;
        }
        throw new IllegalArgumentException("Illegal byte, byte code is " + bytes);
    }
}

