/*
 * Decompiled with CFR 0.152.
 */
package chat.octet.model.utils;

import chat.octet.model.enums.ModelType;
import org.apache.commons.lang3.StringUtils;

public class PromptBuilder {
    public static final String DEFAULT_SYSTEM = "Below is an instruction that describes a task. Write a response that appropriately completes the request.";

    public static String toPrompt(ModelType modelType, String question) {
        return PromptBuilder.toPrompt(modelType, null, question);
    }

    public static String toPrompt(ModelType modelType, String system, String question) {
        String formateSystem = "";
        switch (modelType) {
            case ALPACA: {
                formateSystem = StringUtils.isBlank((CharSequence)system) ? "\n\n" : StringUtils.join((Object[])new String[]{system, "\n\n"});
                return StringUtils.join((Object[])new String[]{formateSystem, "### Instruction:\n", question, "\n\n### Response:\n"});
            }
            case SNOOZY: {
                formateSystem = StringUtils.isBlank((CharSequence)system) ? "\n" : StringUtils.join((Object[])new String[]{"### Instruction:\n", system, "\n\n"});
                return StringUtils.join((Object[])new String[]{formateSystem, "### Prompt\n", question, "\n### Response\n"});
            }
            case VICUNA: {
                formateSystem = StringUtils.isBlank((CharSequence)system) ? "\n\n" : StringUtils.join((Object[])new String[]{system, "\n\n"});
                return StringUtils.join((Object[])new String[]{formateSystem, "USER:\n", question, "\n\nASSISTANT:\n"});
            }
            case OASST_LLAMA: {
                formateSystem = StringUtils.isBlank((CharSequence)system) ? "\n\n" : StringUtils.join((Object[])new String[]{"[INST] <<SYS>>\n", system, "\n<</SYS>>\n\n"});
                return StringUtils.join((Object[])new String[]{formateSystem, "<|prompter|>\n", question, "\n\n<|assistant|>\n"});
            }
            case REDPAJAMA_INCITE: {
                formateSystem = StringUtils.isBlank((CharSequence)system) ? "\n" : StringUtils.join((Object[])new String[]{system, "\n\n"});
                return StringUtils.join((Object[])new String[]{formateSystem, "<human>\n", question, "\n<bot>\n"});
            }
            case LLAMA2: {
                if (StringUtils.isNotBlank((CharSequence)system)) {
                    formateSystem = StringUtils.join((Object[])new String[]{"<<SYS>>\n", system, "\n<</SYS>>\n\n"});
                }
                return StringUtils.join((Object[])new String[]{"[INST] ", formateSystem, question, " [/INST] "});
            }
        }
        formateSystem = StringUtils.isBlank((CharSequence)system) ? "\n" : StringUtils.join((Object[])new String[]{system, "\n\n"});
        return StringUtils.join((Object[])new String[]{formateSystem, "User:\n", question, "\nAssistant:\n"});
    }
}

