/*
 * Decompiled with CFR 0.152.
 */
package chat.octet.model.utils;

import chat.octet.model.exceptions.ModelException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class Platform {
    public static final int UNSPECIFIED = -1;
    public static final int MAC = 0;
    public static final int LINUX = 1;
    public static final int WINDOWS = 2;
    public static final int SOLARIS = 3;
    public static final int FREEBSD = 4;
    public static final int OPENBSD = 5;
    public static final int WINDOWSCE = 6;
    public static final int AIX = 7;
    public static final int ANDROID = 8;
    public static final int GNU = 9;
    public static final int KFREEBSD = 10;
    public static final int NETBSD = 11;
    public static String LIB_RESOURCE_PATH;
    private static final int osType;
    public static final String ARCH;

    private Platform() {
    }

    public static int getOSType() {
        return osType;
    }

    public static boolean isMac() {
        return osType == 0;
    }

    public static boolean isLinux() {
        return osType == 1;
    }

    public static boolean isWindows() {
        return osType == 2 || osType == 6;
    }

    private static String getCanonicalArchitecture(String arch, int platform) {
        if ("powerpc".equals(arch = arch.toLowerCase().trim())) {
            arch = "ppc";
        } else if ("powerpc64".equals(arch)) {
            arch = "ppc64";
        } else if (!"i386".equals(arch) && !"i686".equals(arch)) {
            if (!"x86_64".equals(arch) && !"amd64".equals(arch)) {
                if ("zarch_64".equals(arch)) {
                    arch = "s390x";
                }
            } else {
                arch = "x86-64";
            }
        } else {
            arch = "x86";
        }
        if ("ppc64".equals(arch) && "little".equals(System.getProperty("sun.cpu.endian"))) {
            arch = "ppc64le";
        }
        if ("arm".equals(arch) && platform == 1) {
            arch = "armel";
        }
        return arch;
    }

    public static synchronized void loadLibraryResource() {
        String libraryName;
        File libraryFileAbsolutePath;
        String libPathEnv = System.getProperty("octet.llama.lib");
        if (StringUtils.isNotBlank((CharSequence)libPathEnv) && (libraryFileAbsolutePath = new File(libPathEnv)).exists()) {
            LIB_RESOURCE_PATH = libraryFileAbsolutePath.getAbsolutePath();
            return;
        }
        if (Platform.isMac()) {
            libraryName = "libllama.dylib";
        } else if (Platform.isLinux()) {
            libraryName = "libllama.so";
        } else if (Platform.isWindows()) {
            libraryName = "libllama.dll";
        } else {
            throw new ModelException("Unsupported operating system");
        }
        String userDis = System.getProperty("user.home");
        String libraryPath = Platform.getLibraryResourcePrefix(Platform.getOSType(), System.getProperty("os.arch"), System.getProperty("os.name"));
        String writeFileAbsolutePath = StringUtils.join((Object[])new String[]{userDis, File.separator, ".llama_java_core", File.separator, libraryName});
        File libraryFile = new File(writeFileAbsolutePath);
        try {
            if (libraryFile.exists()) {
                Files.delete(libraryFile.toPath());
            }
            if (!libraryFile.getParentFile().exists()) {
                Files.createDirectory(libraryFile.getParentFile().toPath(), new FileAttribute[0]);
            }
        }
        catch (Exception e) {
            throw new ModelException("Delete old library file error ", e);
        }
        try (InputStream in = Platform.class.getResourceAsStream(File.separator + libraryPath + File.separator + libraryName);
             BufferedInputStream reader = new BufferedInputStream(Objects.requireNonNull(in));
             FileOutputStream out = new FileOutputStream(libraryFile);){
            byte[] buf = new byte[1024];
            while (reader.read(buf) > 0) {
                out.write(buf);
                Arrays.fill(buf, (byte)0);
            }
        }
        catch (Exception e) {
            throw new ModelException("Loading native library error ", e);
        }
        if (!libraryFile.isFile() || !libraryFile.exists()) {
            throw new ModelException("Loading native library failed. file path: " + libraryFile.getAbsolutePath());
        }
        LIB_RESOURCE_PATH = libraryFile.getAbsolutePath();
    }

    private static String getLibraryResourcePrefix(int osType, String arch, String name) {
        String osPrefix;
        arch = Platform.getCanonicalArchitecture(arch, osType);
        switch (osType) {
            case 0: {
                osPrefix = "darwin-" + arch;
                break;
            }
            case 1: {
                osPrefix = "linux-" + arch;
                break;
            }
            case 2: {
                osPrefix = "win32-" + arch;
                break;
            }
            case 3: {
                osPrefix = "sunos-" + arch;
                break;
            }
            case 4: {
                osPrefix = "freebsd-" + arch;
                break;
            }
            case 5: {
                osPrefix = "openbsd-" + arch;
                break;
            }
            case 6: {
                osPrefix = "w32ce-" + arch;
                break;
            }
            default: {
                osPrefix = name.toLowerCase();
                int space = osPrefix.indexOf(" ");
                if (space != -1) {
                    osPrefix = osPrefix.substring(0, space);
                }
                osPrefix = osPrefix + "-" + arch;
                break;
            }
            case 8: {
                if (arch.startsWith("arm")) {
                    arch = "arm";
                }
                osPrefix = "android-" + arch;
                break;
            }
            case 10: {
                osPrefix = "kfreebsd-" + arch;
                break;
            }
            case 11: {
                osPrefix = "netbsd-" + arch;
            }
        }
        return osPrefix;
    }

    static {
        String osName = System.getProperty("os.name");
        osType = osName.startsWith("Linux") ? ("dalvik".equalsIgnoreCase(System.getProperty("java.vm.name")) ? 8 : 1) : (osName.startsWith("AIX") ? 7 : (!osName.startsWith("Mac") && !osName.startsWith("Darwin") ? (osName.startsWith("Windows CE") ? 6 : (osName.startsWith("Windows") ? 2 : (!osName.startsWith("Solaris") && !osName.startsWith("SunOS") ? (osName.startsWith("FreeBSD") ? 4 : (osName.startsWith("OpenBSD") ? 5 : (osName.equalsIgnoreCase("gnu") ? 9 : (osName.equalsIgnoreCase("gnu/kfreebsd") ? 10 : (osName.equalsIgnoreCase("netbsd") ? 11 : -1))))) : 3))) : 0));
        ARCH = Platform.getCanonicalArchitecture(System.getProperty("os.arch"), osType);
        Platform.loadLibraryResource();
    }
}

