/*
 * Decompiled with CFR 0.152.
 */
package chat.octet.model.components.processor.impl;

import chat.octet.model.components.processor.LogitsProcessor;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomBiasLogitsProcessor
implements LogitsProcessor {
    private static final Logger log = LoggerFactory.getLogger(CustomBiasLogitsProcessor.class);
    private final Map<Integer, String> logitBias;
    private final int vocabSize;

    public CustomBiasLogitsProcessor(Map<Integer, String> logitBias, int vocabSize) {
        if (logitBias == null) {
            logitBias = Maps.newLinkedHashMap();
        }
        this.logitBias = logitBias;
        this.vocabSize = vocabSize;
    }

    @Override
    public float[] processor(@Nullable int[] inputTokenIds, @Nonnull float[] scores, Object ... args) {
        for (Map.Entry<Integer, String> entry : this.logitBias.entrySet()) {
            int token = entry.getKey();
            String value = entry.getValue();
            if (token < 0 || token >= this.vocabSize) continue;
            try {
                scores[token] = "false".equalsIgnoreCase(value) ? Float.MIN_VALUE : Float.parseFloat(value);
            }
            catch (Exception e) {
                log.error("Error: ", (Throwable)e);
            }
        }
        return scores;
    }
}

