/*
 * Decompiled with CFR 0.152.
 */
package chat.octet.model;

import chat.octet.model.beans.LlamaContextParams;
import chat.octet.model.beans.LlamaModelParams;
import chat.octet.model.beans.Metrics;
import chat.octet.model.exceptions.DecodeException;
import chat.octet.model.exceptions.ModelException;
import chat.octet.model.utils.Platform;
import com.google.common.base.Preconditions;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import org.apache.commons.lang3.ArrayUtils;

public class LlamaService {
    public static native void initNative();

    public static native LlamaModelParams getLlamaModelDefaultParams();

    public static native LlamaContextParams getLlamaContextDefaultParams();

    public static native void llamaBackendInit(boolean var0);

    public static native void llamaBackendFree();

    public static native void loadLlamaModelFromFile(String var0, LlamaModelParams var1) throws ModelException;

    public static native void createNewContextWithModel(LlamaContextParams var0) throws ModelException;

    public static native void release();

    public static native int getMaxDevices();

    public static native boolean isMmapSupported();

    public static native boolean isMlockSupported();

    public static native int getVocabSize();

    public static native int getContextSize();

    public static native int getEmbeddingSize();

    public static native int getVocabType();

    public static native int loadLoraModelFromFile(String var0, float var1, String var2, int var3) throws ModelException;

    public static native float[] getLogits(int var0);

    public static native float[] getEmbeddings();

    public static native String getTokenText(int var0);

    public static native float getTokenScore(int var0);

    public static native int getTokenType(int var0);

    public static native int getTokenBOS();

    public static native int getTokenEOS();

    public static native int getTokenNL();

    public static native int tokenize(byte[] var0, int var1, int[] var2, int var3, boolean var4);

    public static native int tokenToPiece(int var0, byte[] var1, int var2);

    public static native Metrics getSamplingMetrics(boolean var0);

    public static native String getSystemInfo();

    public static native int sampling(float[] var0, int[] var1, int var2, float var3, float var4, float var5, boolean var6, int var7, float var8, float var9, float var10, int var11, float var12, float var13, float var14, int var15, int var16) throws DecodeException;

    public static native boolean loadLlamaGrammar(String var0);

    public static native int batchDecode(int var0, int[] var1, int var2, int var3);

    public static native void clearCache(int var0, int var1, int var2);

    public static void clearCache(int sequenceId) {
        LlamaService.clearCache(sequenceId, 0, LlamaService.getContextSize());
    }

    public static int[] tokenize(String text, boolean addBos) {
        Preconditions.checkNotNull((Object)text, (Object)"Text cannot be null");
        int[] tokens = new int[LlamaService.getContextSize()];
        byte[] textBytes = text.getBytes(StandardCharsets.UTF_8);
        int nextTokens = LlamaService.tokenize(textBytes, textBytes.length, tokens, LlamaService.getContextSize(), addBos);
        if (nextTokens < 0) {
            throw new ModelException(MessageFormat.format("Failed to tokenize: {0}, next_tokens: {1}", text, nextTokens));
        }
        return ArrayUtils.subarray((int[])tokens, (int)0, (int)nextTokens);
    }

    static {
        System.load(Platform.LIB_RESOURCE_PATH);
        LlamaService.initNative();
        LlamaService.llamaBackendInit(true);
    }
}

