/*
 * Decompiled with CFR 0.152.
 */
package build.buf.protovalidate.internal.expression;

import build.buf.protovalidate.exceptions.ExecutionException;
import build.buf.protovalidate.internal.expression.Expression;
import build.buf.protovalidate.internal.expression.Variable;
import build.buf.validate.Violation;
import javax.annotation.Nullable;
import org.projectnessie.cel.Program;
import org.projectnessie.cel.common.types.Err;
import org.projectnessie.cel.common.types.ref.Val;

public class CompiledProgram {
    private final Program program;
    private final Expression source;

    public CompiledProgram(Program program, Expression source) {
        this.program = program;
        this.source = source;
    }

    @Nullable
    public Violation eval(Variable bindings) throws ExecutionException {
        Program.EvalResult evalResult = this.program.eval((Object)bindings);
        Val val = evalResult.getVal();
        if (val instanceof Err) {
            throw new ExecutionException(String.format("error evaluating %s: %s", this.source.id, val));
        }
        Object value = val.value();
        if (value instanceof String) {
            if ("".equals(value)) {
                return null;
            }
            return Violation.newBuilder().setConstraintId(this.source.id).setMessage(value.toString()).build();
        }
        if (value instanceof Boolean) {
            if (val.booleanValue()) {
                return null;
            }
            return Violation.newBuilder().setConstraintId(this.source.id).setMessage(this.source.message).build();
        }
        throw new ExecutionException(String.format("resolved to an unexpected type %s", val));
    }
}

