/*
 * Decompiled with CFR 0.152.
 */
package build.buf.protovalidate.internal.evaluator;

import build.buf.protovalidate.ValidationResult;
import build.buf.protovalidate.exceptions.ExecutionException;
import build.buf.protovalidate.internal.evaluator.Evaluator;
import build.buf.protovalidate.internal.evaluator.Value;
import build.buf.validate.Violation;
import com.google.protobuf.Descriptors;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

class EnumEvaluator
implements Evaluator {
    private final Set<Integer> values;

    EnumEvaluator(List<Descriptors.EnumValueDescriptor> valueDescriptors) {
        this.values = valueDescriptors.isEmpty() ? Collections.emptySet() : valueDescriptors.stream().map(Descriptors.EnumValueDescriptor::getNumber).collect(Collectors.toSet());
    }

    @Override
    public boolean tautology() {
        return false;
    }

    @Override
    public ValidationResult evaluate(Value val, boolean failFast) throws ExecutionException {
        Descriptors.EnumValueDescriptor enumValue = val.value(Descriptors.EnumValueDescriptor.class);
        if (enumValue == null) {
            return ValidationResult.EMPTY;
        }
        if (!this.values.contains(enumValue.getNumber())) {
            return new ValidationResult(Collections.singletonList(Violation.newBuilder().setConstraintId("enum.defined_only").setMessage("value must be one of the defined enum values").build()));
        }
        return ValidationResult.EMPTY;
    }
}

