/*
 * Decompiled with CFR 0.152.
 */
package build.buf.protovalidate.internal.evaluator;

import build.buf.protovalidate.ValidationResult;
import build.buf.protovalidate.exceptions.ExecutionException;
import build.buf.protovalidate.internal.evaluator.Evaluator;
import build.buf.protovalidate.internal.evaluator.Value;
import build.buf.validate.Violation;
import java.util.ArrayList;
import java.util.List;

class MessageEvaluator
implements Evaluator {
    private final List<Evaluator> evaluators = new ArrayList<Evaluator>();

    MessageEvaluator() {
    }

    @Override
    public boolean tautology() {
        for (Evaluator evaluator : this.evaluators) {
            if (evaluator.tautology()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ValidationResult evaluate(Value val, boolean failFast) throws ExecutionException {
        ArrayList<Violation> violations = new ArrayList<Violation>();
        for (Evaluator evaluator : this.evaluators) {
            ValidationResult evalResult = evaluator.evaluate(val, failFast);
            if (failFast && !evalResult.getViolations().isEmpty()) {
                return evalResult;
            }
            violations.addAll(evalResult.getViolations());
        }
        if (violations.isEmpty()) {
            return ValidationResult.EMPTY;
        }
        return new ValidationResult(violations);
    }

    public void append(Evaluator eval) {
        this.evaluators.add(eval);
    }
}

