/*
 * Decompiled with CFR 0.152.
 */
package build.buf.protovalidate.internal.constraints;

import build.buf.protovalidate.exceptions.CompilationException;
import build.buf.protovalidate.internal.constraints.DescriptorMappings;
import build.buf.protovalidate.internal.expression.AstExpression;
import build.buf.protovalidate.internal.expression.CompiledProgram;
import build.buf.protovalidate.internal.expression.Expression;
import build.buf.protovalidate.internal.expression.Variable;
import build.buf.validate.priv.FieldConstraints;
import build.buf.validate.priv.PrivateProto;
import com.google.api.expr.v1alpha1.Decl;
import com.google.api.expr.v1alpha1.Type;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.projectnessie.cel.Ast;
import org.projectnessie.cel.Env;
import org.projectnessie.cel.EnvOption;
import org.projectnessie.cel.EvalOption;
import org.projectnessie.cel.Program;
import org.projectnessie.cel.ProgramOption;
import org.projectnessie.cel.checker.Decls;
import org.projectnessie.cel.common.types.ref.Val;
import org.projectnessie.cel.interpreter.Activation;

public class ConstraintCache {
    private static final ProgramOption PARTIAL_EVAL_OPTIONS = ProgramOption.evalOptions((EvalOption[])new EvalOption[]{EvalOption.OptTrackState, EvalOption.OptExhaustiveEval, EvalOption.OptOptimize, EvalOption.OptPartialEval});
    private static final Map<Descriptors.FieldDescriptor, List<AstExpression>> descriptorMap = new ConcurrentHashMap<Descriptors.FieldDescriptor, List<AstExpression>>();
    private final Env env;

    public ConstraintCache(Env env) {
        this.env = env;
    }

    public List<CompiledProgram> compile(Descriptors.FieldDescriptor fieldDescriptor, build.buf.validate.FieldConstraints fieldConstraints, boolean forItems) throws CompilationException {
        Message message = this.resolveConstraints(fieldDescriptor, fieldConstraints, forItems);
        if (message == null) {
            return Collections.emptyList();
        }
        Env finalEnv = this.env.extend(new EnvOption[]{EnvOption.types((Object[])new Object[]{message.getDefaultInstanceForType()}), EnvOption.declarations((Decl[])new Decl[]{Decls.newVar((String)"this", (Type)DescriptorMappings.getCELType(fieldDescriptor, forItems)), Decls.newVar((String)"rules", (Type)Decls.newObjectType((String)message.getDescriptorForType().getFullName()))})});
        ProgramOption rulesOption = ProgramOption.globals((Object)Variable.newRulesVariable(message));
        ArrayList<AstExpression> completeProgramList = new ArrayList<AstExpression>();
        for (Map.Entry entry : message.getAllFields().entrySet()) {
            Descriptors.FieldDescriptor constraintFieldDesc = (Descriptors.FieldDescriptor)entry.getKey();
            if (!descriptorMap.containsKey(constraintFieldDesc)) {
                FieldConstraints constraints = (FieldConstraints)constraintFieldDesc.getOptions().getExtension(PrivateProto.field);
                List<Expression> expressions = Expression.fromPrivConstraints(constraints.getCelList());
                ArrayList<AstExpression> astExpressions = new ArrayList<AstExpression>();
                for (Expression expression : expressions) {
                    astExpressions.add(AstExpression.newAstExpression(finalEnv, expression));
                }
                descriptorMap.put(constraintFieldDesc, astExpressions);
            }
            List<AstExpression> programList = descriptorMap.get(constraintFieldDesc);
            completeProgramList.addAll(programList);
        }
        ArrayList<CompiledProgram> programs = new ArrayList<CompiledProgram>();
        for (AstExpression astExpression : completeProgramList) {
            try {
                Object val;
                Program program = finalEnv.program(astExpression.ast, new ProgramOption[]{rulesOption, PARTIAL_EVAL_OPTIONS});
                Program.EvalResult evalResult = program.eval((Object)Activation.emptyActivation());
                Val value = evalResult.getVal();
                if (value != null && ((val = value.value()) instanceof Boolean && value.booleanValue() || val instanceof String && val.equals(""))) continue;
                Ast residual = finalEnv.residualAst(astExpression.ast, evalResult.getEvalDetails());
                programs.add(new CompiledProgram(finalEnv.program(residual, new ProgramOption[]{rulesOption}), astExpression.source));
            }
            catch (Exception e) {
                programs.add(new CompiledProgram(finalEnv.program(astExpression.ast, new ProgramOption[]{rulesOption}), astExpression.source));
            }
        }
        return Collections.unmodifiableList(programs);
    }

    @Nullable
    private Message resolveConstraints(Descriptors.FieldDescriptor fieldDescriptor, build.buf.validate.FieldConstraints fieldConstraints, boolean forItems) throws CompilationException {
        Descriptors.FieldDescriptor oneofFieldDescriptor = fieldConstraints.getOneofFieldDescriptor(DescriptorMappings.FIELD_CONSTRAINTS_ONEOF_DESC);
        if (oneofFieldDescriptor == null) {
            return null;
        }
        Descriptors.FieldDescriptor expectedConstraintDescriptor = DescriptorMappings.getExpectedConstraintDescriptor(fieldDescriptor, forItems);
        if (expectedConstraintDescriptor != null && !oneofFieldDescriptor.getFullName().equals(expectedConstraintDescriptor.getFullName())) {
            throw new CompilationException(String.format("expected constraint %s, got %s on field %s", expectedConstraintDescriptor.getName(), oneofFieldDescriptor.getName(), fieldDescriptor.getName()));
        }
        if (expectedConstraintDescriptor == null || !fieldConstraints.hasField(oneofFieldDescriptor)) {
            return null;
        }
        return (Message)fieldConstraints.getField(oneofFieldDescriptor);
    }
}

