/*
 * Decompiled with CFR 0.152.
 */
package build.buf.protovalidate.internal.celext;

import build.buf.protovalidate.internal.celext.Format;
import com.google.common.base.Ascii;
import com.google.common.base.Splitter;
import com.google.common.net.InetAddresses;
import com.google.common.primitives.Bytes;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressString;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashSet;
import org.projectnessie.cel.common.types.BoolT;
import org.projectnessie.cel.common.types.Err;
import org.projectnessie.cel.common.types.IntT;
import org.projectnessie.cel.common.types.ListT;
import org.projectnessie.cel.common.types.StringT;
import org.projectnessie.cel.common.types.Types;
import org.projectnessie.cel.common.types.ref.TypeEnum;
import org.projectnessie.cel.common.types.ref.Val;
import org.projectnessie.cel.common.types.traits.Lister;
import org.projectnessie.cel.interpreter.functions.Overload;

final class CustomOverload {
    private static final String OVERLOAD_FORMAT = "format";
    private static final String OVERLOAD_UNIQUE = "unique";
    private static final String OVERLOAD_STARTS_WITH = "startsWith";
    private static final String OVERLOAD_ENDS_WITH = "endsWith";
    private static final String OVERLOAD_CONTAINS = "contains";
    private static final String OVERLOAD_IS_HOSTNAME = "isHostname";
    private static final String OVERLOAD_IS_EMAIL = "isEmail";
    private static final String OVERLOAD_IS_IP = "isIp";
    private static final String OVERLOAD_IS_IP_PREFIX = "isIpPrefix";
    private static final String OVERLOAD_IS_URI = "isUri";
    private static final String OVERLOAD_IS_URI_REF = "isUriRef";
    private static final String OVERLOAD_IS_NAN = "isNan";
    private static final String OVERLOAD_IS_INF = "isInf";
    private static final String OVERLOAD_IS_HOST_AND_PORT = "isHostAndPort";

    CustomOverload() {
    }

    static Overload[] create() {
        return new Overload[]{CustomOverload.format(), CustomOverload.unique(), CustomOverload.startsWith(), CustomOverload.endsWith(), CustomOverload.contains(), CustomOverload.isHostname(), CustomOverload.isEmail(), CustomOverload.isIp(), CustomOverload.isIpPrefix(), CustomOverload.isUri(), CustomOverload.isUriRef(), CustomOverload.isNan(), CustomOverload.isInf(), CustomOverload.isHostAndPort()};
    }

    private static Overload format() {
        return Overload.binary((String)OVERLOAD_FORMAT, (lhs, rhs) -> {
            if (lhs.type().typeEnum() != TypeEnum.String || rhs.type().typeEnum() != TypeEnum.List) {
                return Err.noSuchOverload((Val)lhs, (String)OVERLOAD_FORMAT, (Val)rhs);
            }
            ListT list = (ListT)rhs.convertToType(ListT.ListType);
            String formatString = (String)lhs.value();
            try {
                return StringT.stringOf((String)Format.format(formatString, list));
            }
            catch (Err.ErrException e) {
                return e.getErr();
            }
        });
    }

    private static Overload unique() {
        return Overload.unary((String)OVERLOAD_UNIQUE, val -> {
            if (val.type().typeEnum() != TypeEnum.List) {
                return Err.noSuchOverload((Val)val, (String)OVERLOAD_UNIQUE, null);
            }
            return CustomOverload.uniqueList((Lister)val);
        });
    }

    private static Overload startsWith() {
        return Overload.binary((String)OVERLOAD_STARTS_WITH, (lhs, rhs) -> {
            TypeEnum lhsType = lhs.type().typeEnum();
            if (lhsType != rhs.type().typeEnum()) {
                return Err.noSuchOverload((Val)lhs, (String)OVERLOAD_STARTS_WITH, (Val)rhs);
            }
            if (lhsType == TypeEnum.String) {
                String receiver = lhs.value().toString();
                String param = rhs.value().toString();
                return Types.boolOf((boolean)receiver.startsWith(param));
            }
            if (lhsType == TypeEnum.Bytes) {
                byte[] param;
                byte[] receiver = (byte[])lhs.value();
                if (receiver.length < (param = (byte[])rhs.value()).length) {
                    return BoolT.False;
                }
                for (int i = 0; i < param.length; ++i) {
                    if (param[i] == receiver[i]) continue;
                    return BoolT.False;
                }
                return BoolT.True;
            }
            return Err.noSuchOverload((Val)lhs, (String)OVERLOAD_STARTS_WITH, (Val)rhs);
        });
    }

    private static Overload endsWith() {
        return Overload.binary((String)OVERLOAD_ENDS_WITH, (lhs, rhs) -> {
            TypeEnum lhsType = lhs.type().typeEnum();
            if (lhsType != rhs.type().typeEnum()) {
                return Err.noSuchOverload((Val)lhs, (String)OVERLOAD_ENDS_WITH, (Val)rhs);
            }
            if (lhsType == TypeEnum.String) {
                String receiver = (String)lhs.value();
                String param = (String)rhs.value();
                return Types.boolOf((boolean)receiver.endsWith(param));
            }
            if (lhsType == TypeEnum.Bytes) {
                byte[] param;
                byte[] receiver = (byte[])lhs.value();
                if (receiver.length < (param = (byte[])rhs.value()).length) {
                    return BoolT.False;
                }
                for (int i = 0; i < param.length; ++i) {
                    if (param[param.length - i - 1] == receiver[receiver.length - i - 1]) continue;
                    return BoolT.False;
                }
                return BoolT.True;
            }
            return Err.noSuchOverload((Val)lhs, (String)OVERLOAD_ENDS_WITH, (Val)rhs);
        });
    }

    private static Overload contains() {
        return Overload.binary((String)OVERLOAD_CONTAINS, (lhs, rhs) -> {
            TypeEnum lhsType = lhs.type().typeEnum();
            if (lhsType != rhs.type().typeEnum()) {
                return Err.noSuchOverload((Val)lhs, (String)OVERLOAD_CONTAINS, (Val)rhs);
            }
            if (lhsType == TypeEnum.String) {
                String receiver = lhs.value().toString();
                String param = rhs.value().toString();
                return Types.boolOf((boolean)receiver.contains(param));
            }
            if (lhsType == TypeEnum.Bytes) {
                byte[] param;
                byte[] receiver = (byte[])lhs.value();
                return Types.boolOf((Bytes.indexOf((byte[])receiver, (byte[])(param = (byte[])rhs.value())) != -1 ? 1 : 0) != 0);
            }
            return Err.noSuchOverload((Val)lhs, (String)OVERLOAD_CONTAINS, (Val)rhs);
        });
    }

    private static Overload isHostname() {
        return Overload.unary((String)OVERLOAD_IS_HOSTNAME, value -> {
            if (value.type().typeEnum() != TypeEnum.String) {
                return Err.noSuchOverload((Val)value, (String)OVERLOAD_IS_HOSTNAME, null);
            }
            String host = (String)value.value();
            if (host.isEmpty()) {
                return BoolT.False;
            }
            return Types.boolOf((boolean)CustomOverload.validateHostname(host));
        });
    }

    private static Overload isEmail() {
        return Overload.unary((String)OVERLOAD_IS_EMAIL, value -> {
            if (value.type().typeEnum() != TypeEnum.String) {
                return Err.noSuchOverload((Val)value, (String)OVERLOAD_IS_EMAIL, null);
            }
            String addr = (String)value.value();
            if (addr.isEmpty()) {
                return BoolT.False;
            }
            return Types.boolOf((boolean)CustomOverload.validateEmail(addr));
        });
    }

    private static Overload isIp() {
        return Overload.overload((String)OVERLOAD_IS_IP, null, value -> {
            if (value.type().typeEnum() != TypeEnum.String) {
                return Err.noSuchOverload((Val)value, (String)OVERLOAD_IS_IP, null);
            }
            String addr = (String)value.value();
            if (addr.isEmpty()) {
                return BoolT.False;
            }
            return Types.boolOf((boolean)CustomOverload.validateIP(addr, 0L));
        }, (lhs, rhs) -> {
            if (lhs.type().typeEnum() != TypeEnum.String || rhs.type().typeEnum() != TypeEnum.Int) {
                return Err.noSuchOverload((Val)lhs, (String)OVERLOAD_IS_IP, (Val)rhs);
            }
            String address = (String)lhs.value();
            if (address.isEmpty()) {
                return BoolT.False;
            }
            return Types.boolOf((boolean)CustomOverload.validateIP(address, rhs.intValue()));
        }, null);
    }

    private static Overload isIpPrefix() {
        return Overload.overload((String)OVERLOAD_IS_IP_PREFIX, null, value -> {
            if (value.type().typeEnum() != TypeEnum.String && value.type().typeEnum() != TypeEnum.Bool) {
                return Err.noSuchOverload((Val)value, (String)OVERLOAD_IS_IP_PREFIX, null);
            }
            String prefix = (String)value.value();
            if (prefix.isEmpty()) {
                return BoolT.False;
            }
            return Types.boolOf((boolean)CustomOverload.validateIPPrefix(prefix, 0L, false));
        }, (lhs, rhs) -> {
            if (lhs.type().typeEnum() != TypeEnum.String || rhs.type().typeEnum() != TypeEnum.Int && rhs.type().typeEnum() != TypeEnum.Bool) {
                return Err.noSuchOverload((Val)lhs, (String)OVERLOAD_IS_IP_PREFIX, (Val)rhs);
            }
            String prefix = (String)lhs.value();
            if (prefix.isEmpty()) {
                return BoolT.False;
            }
            if (rhs.type().typeEnum() == TypeEnum.Int) {
                return Types.boolOf((boolean)CustomOverload.validateIPPrefix(prefix, rhs.intValue(), false));
            }
            return Types.boolOf((boolean)CustomOverload.validateIPPrefix(prefix, 0L, rhs.booleanValue()));
        }, values -> {
            if (values.length != 3 || values[0].type().typeEnum() != TypeEnum.String || values[1].type().typeEnum() != TypeEnum.Int || values[2].type().typeEnum() != TypeEnum.Bool) {
                return Err.noSuchOverload((Val)values[0], (String)OVERLOAD_IS_IP_PREFIX, (String)"", (Val[])values);
            }
            String prefix = (String)values[0].value();
            if (prefix.isEmpty()) {
                return BoolT.False;
            }
            return Types.boolOf((boolean)CustomOverload.validateIPPrefix(prefix, values[1].intValue(), values[2].booleanValue()));
        });
    }

    private static Overload isUri() {
        return Overload.unary((String)OVERLOAD_IS_URI, value -> {
            if (value.type().typeEnum() != TypeEnum.String) {
                return Err.noSuchOverload((Val)value, (String)OVERLOAD_IS_URI, null);
            }
            String addr = (String)value.value();
            if (addr.isEmpty()) {
                return BoolT.False;
            }
            try {
                return Types.boolOf((boolean)new URL(addr).toURI().isAbsolute());
            }
            catch (MalformedURLException | URISyntaxException e) {
                return BoolT.False;
            }
        });
    }

    private static Overload isUriRef() {
        return Overload.unary((String)OVERLOAD_IS_URI_REF, value -> {
            if (value.type().typeEnum() != TypeEnum.String) {
                return Err.noSuchOverload((Val)value, (String)OVERLOAD_IS_URI_REF, null);
            }
            String addr = (String)value.value();
            if (addr.isEmpty()) {
                return BoolT.False;
            }
            try {
                String host = "http://protovalidate.buf.build";
                URL url = new URL(host + addr);
                return Types.boolOf((url.getPath() != null && !url.getPath().isEmpty() ? 1 : 0) != 0);
            }
            catch (MalformedURLException e) {
                return BoolT.False;
            }
        });
    }

    private static Overload isNan() {
        return Overload.unary((String)OVERLOAD_IS_NAN, value -> {
            if (value.type().typeEnum() != TypeEnum.Double) {
                return Err.noSuchOverload((Val)value, (String)OVERLOAD_IS_NAN, null);
            }
            Double doubleVal = (Double)value.value();
            return Types.boolOf((boolean)doubleVal.isNaN());
        });
    }

    private static Overload isInf() {
        return Overload.overload((String)OVERLOAD_IS_INF, null, value -> {
            if (value.type().typeEnum() != TypeEnum.Double) {
                return Err.noSuchOverload((Val)value, (String)OVERLOAD_IS_INF, null);
            }
            Double doubleVal = (Double)value.value();
            return Types.boolOf((boolean)doubleVal.isInfinite());
        }, (lhs, rhs) -> {
            if (lhs.type().typeEnum() != TypeEnum.Double || rhs.type().typeEnum() != TypeEnum.Int) {
                return Err.noSuchOverload((Val)lhs, (String)OVERLOAD_IS_INF, (Val)rhs);
            }
            Double value = (Double)lhs.value();
            long sign = rhs.intValue();
            if (sign == 0L) {
                return Types.boolOf((boolean)value.isInfinite());
            }
            double expectedValue = sign > 0L ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
            return Types.boolOf((value == expectedValue ? 1 : 0) != 0);
        }, null);
    }

    private static Overload isHostAndPort() {
        return Overload.overload((String)OVERLOAD_IS_HOST_AND_PORT, null, null, (lhs, rhs) -> {
            if (lhs.type().typeEnum() != TypeEnum.String || rhs.type().typeEnum() != TypeEnum.Bool) {
                return Err.noSuchOverload((Val)lhs, (String)OVERLOAD_IS_HOST_AND_PORT, (Val)rhs);
            }
            String value = (String)lhs.value();
            boolean portRequired = rhs.booleanValue();
            return Types.boolOf((boolean)CustomOverload.hostAndPort(value, portRequired));
        }, null);
    }

    private static boolean hostAndPort(String value, boolean portRequired) {
        if (value.isEmpty()) {
            return false;
        }
        int splitIdx = value.lastIndexOf(58);
        if (value.charAt(0) == '[') {
            int end = value.indexOf(93);
            if (end + 1 == value.length()) {
                return !portRequired && CustomOverload.validateIP(value.substring(1, end), 6L);
            }
            if (end + 1 == splitIdx) {
                return CustomOverload.validateIP(value.substring(1, end), 6L) && CustomOverload.validatePort(value.substring(splitIdx + 1));
            }
            return false;
        }
        if (splitIdx < 0) {
            return !portRequired && (CustomOverload.validateHostname(value) || CustomOverload.validateIP(value, 4L));
        }
        String host = value.substring(0, splitIdx);
        String port = value.substring(splitIdx + 1);
        return (CustomOverload.validateHostname(host) || CustomOverload.validateIP(host, 4L)) && CustomOverload.validatePort(port);
    }

    private static boolean validatePort(String value) {
        try {
            int portNum = Integer.parseInt(value);
            return portNum >= 0 && portNum <= 65535;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    private static Val uniqueList(Lister list) {
        long size = list.size().intValue();
        if (size == 0L) {
            return BoolT.True;
        }
        HashSet<Val> exist = new HashSet<Val>((int)size);
        Val firstVal = list.get((Val)IntT.intOf((long)0L));
        switch (firstVal.type().typeEnum()) {
            case Bool: 
            case Int: 
            case Uint: 
            case Double: 
            case String: 
            case Bytes: {
                break;
            }
            default: {
                return Err.noSuchOverload((Val)list, (String)OVERLOAD_UNIQUE, null);
            }
        }
        exist.add(firstVal);
        int i = 1;
        while ((long)i < size) {
            Val val = list.get((Val)IntT.intOf((long)i));
            if (!exist.add(val)) {
                return BoolT.False;
            }
            ++i;
        }
        return BoolT.True;
    }

    private static boolean validateEmail(String addr) {
        try {
            InternetAddress emailAddr = new InternetAddress(addr);
            emailAddr.validate();
            if (addr.contains("<") || !emailAddr.getAddress().equals(addr)) {
                return false;
            }
            addr = emailAddr.getAddress();
            if (addr.length() > 254) {
                return false;
            }
            String[] parts = addr.split("@", 2);
            return parts[0].length() < 64 && CustomOverload.validateHostname(parts[1]);
        }
        catch (AddressException ex) {
            return false;
        }
    }

    private static boolean validateHostname(String host) {
        if (host.length() > 253) {
            return false;
        }
        String s = Ascii.toLowerCase((String)(host.endsWith(".") ? host.substring(0, host.length() - 1) : host));
        Iterable parts = Splitter.on((char)'.').split((CharSequence)s);
        boolean allDigits = false;
        for (String part : parts) {
            allDigits = true;
            int l = part.length();
            if (l == 0 || l > 63 || part.charAt(0) == '-' || part.charAt(l - 1) == '-') {
                return false;
            }
            for (int i = 0; i < l; ++i) {
                char ch = part.charAt(i);
                if (!Ascii.isLowerCase((char)ch) && !CustomOverload.isDigit(ch) && ch != '-') {
                    return false;
                }
                allDigits = allDigits && CustomOverload.isDigit(ch);
            }
        }
        return !allDigits;
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean validateIP(String addr, long ver) {
        InetAddress address;
        try {
            address = InetAddresses.forString((String)addr);
        }
        catch (Exception e) {
            return false;
        }
        if (ver == 0L) {
            return true;
        }
        if (ver == 4L) {
            return address instanceof Inet4Address;
        }
        if (ver == 6L) {
            return address instanceof Inet6Address;
        }
        return false;
    }

    private static boolean validateIPPrefix(String prefix, long ver, boolean strict) {
        IPAddress mask;
        IPAddress addr;
        IPAddressString str;
        try {
            str = new IPAddressString(prefix);
            addr = str.toAddress();
        }
        catch (Exception e) {
            return false;
        }
        if (!addr.isPrefixed()) {
            return false;
        }
        if (strict && !addr.mask(mask = addr.getNetworkMask().withoutPrefixLength()).equals((Object)str.getHostAddress())) {
            return false;
        }
        if (ver == 0L) {
            return true;
        }
        if (ver == 4L) {
            return addr.isIPv4();
        }
        if (ver == 6L) {
            return addr.isIPv6();
        }
        return false;
    }
}

