/*
 * Decompiled with CFR 0.152.
 */
package build.buf.protovalidate;

import build.buf.protovalidate.Config;
import build.buf.protovalidate.ValidationResult;
import build.buf.protovalidate.exceptions.CompilationException;
import build.buf.protovalidate.exceptions.ValidationException;
import build.buf.protovalidate.internal.celext.ValidateLibrary;
import build.buf.protovalidate.internal.evaluator.Evaluator;
import build.buf.protovalidate.internal.evaluator.EvaluatorBuilder;
import build.buf.protovalidate.internal.evaluator.MessageValue;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import org.projectnessie.cel.Env;
import org.projectnessie.cel.EnvOption;
import org.projectnessie.cel.Library;

public class Validator {
    private final EvaluatorBuilder evaluatorBuilder;
    private final boolean failFast;

    public Validator(Config config) {
        Env env = Env.newEnv((EnvOption[])new EnvOption[]{Library.Lib((Library)new ValidateLibrary())});
        this.evaluatorBuilder = new EvaluatorBuilder(env, config.isDisableLazy());
        this.failFast = config.isFailFast();
    }

    public Validator() {
        Config config = Config.newBuilder().build();
        Env env = Env.newEnv((EnvOption[])new EnvOption[]{Library.Lib((Library)new ValidateLibrary())});
        this.evaluatorBuilder = new EvaluatorBuilder(env, config.isDisableLazy());
        this.failFast = config.isFailFast();
    }

    public ValidationResult validate(Message msg) throws ValidationException {
        if (msg == null) {
            return ValidationResult.EMPTY;
        }
        Descriptors.Descriptor descriptor = msg.getDescriptorForType();
        Evaluator evaluator = this.evaluatorBuilder.load(descriptor);
        return evaluator.evaluate(new MessageValue(msg), this.failFast);
    }

    public void loadMessages(Message ... messages) throws CompilationException {
        for (Message message : messages) {
            this.evaluatorBuilder.load(message.getDescriptorForType());
        }
    }

    public void loadDescriptors(Descriptors.Descriptor ... descriptors) throws CompilationException {
        for (Descriptors.Descriptor descriptor : descriptors) {
            this.evaluatorBuilder.load(descriptor);
        }
    }
}

