/*
 * Decompiled with CFR 0.152.
 */
package io.envoyproxy.pgv.grpc;

import io.envoyproxy.pgv.ValidationException;
import io.envoyproxy.pgv.ValidatorIndex;
import io.envoyproxy.pgv.grpc.ValidationExceptions;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.MethodDescriptor;

public class ValidatingClientInterceptor
implements ClientInterceptor {
    private final ValidatorIndex index;

    public ValidatingClientInterceptor(ValidatorIndex index) {
        this.index = index;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

            public void sendMessage(ReqT message) {
                try {
                    ValidatingClientInterceptor.this.index.validatorFor(message.getClass()).assertValid(message);
                    super.sendMessage(message);
                }
                catch (ValidationException ex) {
                    throw ValidationExceptions.asStatusRuntimeException(ex);
                }
            }
        };
    }
}

