/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.moshi.internal;

import com.squareup.moshi.Json;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonClass;
import com.squareup.moshi.JsonDataException;
import com.squareup.moshi.JsonQualifier;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nullable;

public final class Util {
    public static final Set<Annotation> NO_ANNOTATIONS = Collections.emptySet();
    public static final Type[] EMPTY_TYPE_ARRAY = new Type[0];
    @Nullable
    public static final Class<?> DEFAULT_CONSTRUCTOR_MARKER;
    @Nullable
    private static final Class<? extends Annotation> METADATA;
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TO_WRAPPER_TYPE;

    private static String getKotlinMetadataClassName() {
        return "kotlin.Metadata";
    }

    private Util() {
    }

    public static String jsonName(String declaredName, AnnotatedElement element) {
        return Util.jsonName(declaredName, element.getAnnotation(Json.class));
    }

    public static String jsonName(String declaredName, @Nullable Json annotation) {
        if (annotation == null) {
            return declaredName;
        }
        String annotationName = annotation.name();
        return "\u0000".equals(annotationName) ? declaredName : annotationName;
    }

    public static boolean typesMatch(Type pattern, Type candidate) {
        return Types.equals(pattern, candidate);
    }

    public static Set<? extends Annotation> jsonAnnotations(AnnotatedElement annotatedElement) {
        return Util.jsonAnnotations(annotatedElement.getAnnotations());
    }

    public static Set<? extends Annotation> jsonAnnotations(Annotation[] annotations2) {
        LinkedHashSet<Annotation> result2 = null;
        for (Annotation annotation : annotations2) {
            if (!annotation.annotationType().isAnnotationPresent(JsonQualifier.class)) continue;
            if (result2 == null) {
                result2 = new LinkedHashSet<Annotation>();
            }
            result2.add(annotation);
        }
        return result2 != null ? Collections.unmodifiableSet(result2) : NO_ANNOTATIONS;
    }

    public static boolean isAnnotationPresent(Set<? extends Annotation> annotations2, Class<? extends Annotation> annotationClass) {
        if (annotations2.isEmpty()) {
            return false;
        }
        for (Annotation annotation : annotations2) {
            if (annotation.annotationType() != annotationClass) continue;
            return true;
        }
        return false;
    }

    public static boolean hasNullable(Annotation[] annotations2) {
        for (Annotation annotation : annotations2) {
            if (!annotation.annotationType().getSimpleName().equals("Nullable")) continue;
            return true;
        }
        return false;
    }

    public static boolean isPlatformType(Class<?> rawType) {
        String name = rawType.getName();
        return name.startsWith("android.") || name.startsWith("androidx.") || name.startsWith("java.") || name.startsWith("javax.") || name.startsWith("kotlin.") || name.startsWith("kotlinx.") || name.startsWith("scala.");
    }

    public static RuntimeException rethrowCause(InvocationTargetException e) {
        Throwable cause = e.getTargetException();
        if (cause instanceof RuntimeException) {
            throw (RuntimeException)cause;
        }
        if (cause instanceof Error) {
            throw (Error)cause;
        }
        throw new RuntimeException(cause);
    }

    public static Type canonicalize(Type type2) {
        if (type2 instanceof Class) {
            Class c = (Class)type2;
            return c.isArray() ? new GenericArrayTypeImpl(Util.canonicalize(c.getComponentType())) : c;
        }
        if (type2 instanceof ParameterizedType) {
            if (type2 instanceof ParameterizedTypeImpl) {
                return type2;
            }
            ParameterizedType p = (ParameterizedType)type2;
            return new ParameterizedTypeImpl(p.getOwnerType(), p.getRawType(), p.getActualTypeArguments());
        }
        if (type2 instanceof GenericArrayType) {
            if (type2 instanceof GenericArrayTypeImpl) {
                return type2;
            }
            GenericArrayType g = (GenericArrayType)type2;
            return new GenericArrayTypeImpl(g.getGenericComponentType());
        }
        if (type2 instanceof WildcardType) {
            if (type2 instanceof WildcardTypeImpl) {
                return type2;
            }
            WildcardType w = (WildcardType)type2;
            return new WildcardTypeImpl(w.getUpperBounds(), w.getLowerBounds());
        }
        return type2;
    }

    public static Type removeSubtypeWildcard(Type type2) {
        if (!(type2 instanceof WildcardType)) {
            return type2;
        }
        Type[] lowerBounds = ((WildcardType)type2).getLowerBounds();
        if (lowerBounds.length != 0) {
            return type2;
        }
        Type[] upperBounds2 = ((WildcardType)type2).getUpperBounds();
        if (upperBounds2.length != 1) {
            throw new IllegalArgumentException();
        }
        return upperBounds2[0];
    }

    public static Type resolve(Type context, Class<?> contextRawType, Type toResolve) {
        return Util.resolve(context, contextRawType, toResolve, new LinkedHashSet());
    }

    private static Type resolve(Type context, Class<?> contextRawType, Type toResolve, Collection<TypeVariable<?>> visitedTypeVariables) {
        Type original;
        while (toResolve instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)toResolve;
            if (visitedTypeVariables.contains(typeVariable)) {
                return toResolve;
            }
            visitedTypeVariables.add(typeVariable);
            toResolve = Util.resolveTypeVariable(context, contextRawType, typeVariable);
            if (toResolve != typeVariable) continue;
            return toResolve;
        }
        if (toResolve instanceof Class && ((Class)toResolve).isArray()) {
            Type newComponentType;
            original = (Class)toResolve;
            Class<?> componentType = ((Class)original).getComponentType();
            return componentType == (newComponentType = Util.resolve(context, contextRawType, componentType, visitedTypeVariables)) ? original : Types.arrayOf(newComponentType);
        }
        if (toResolve instanceof GenericArrayType) {
            Type newComponentType;
            original = (GenericArrayType)toResolve;
            Type componentType = original.getGenericComponentType();
            return componentType == (newComponentType = Util.resolve(context, contextRawType, componentType, visitedTypeVariables)) ? original : Types.arrayOf(newComponentType);
        }
        if (toResolve instanceof ParameterizedType) {
            original = (ParameterizedType)toResolve;
            Type ownerType = original.getOwnerType();
            Type newOwnerType = Util.resolve(context, contextRawType, ownerType, visitedTypeVariables);
            boolean changed = newOwnerType != ownerType;
            Type[] args2 = original.getActualTypeArguments();
            int length = args2.length;
            for (int t = 0; t < length; ++t) {
                Type resolvedTypeArgument = Util.resolve(context, contextRawType, args2[t], visitedTypeVariables);
                if (resolvedTypeArgument == args2[t]) continue;
                if (!changed) {
                    args2 = (Type[])args2.clone();
                    changed = true;
                }
                args2[t] = resolvedTypeArgument;
            }
            return changed ? new ParameterizedTypeImpl(newOwnerType, original.getRawType(), args2) : original;
        }
        if (toResolve instanceof WildcardType) {
            Type upperBound;
            original = (WildcardType)toResolve;
            Type[] originalLowerBound = original.getLowerBounds();
            Type[] originalUpperBound = original.getUpperBounds();
            if (originalLowerBound.length == 1) {
                Type lowerBound = Util.resolve(context, contextRawType, originalLowerBound[0], visitedTypeVariables);
                if (lowerBound != originalLowerBound[0]) {
                    return Types.supertypeOf(lowerBound);
                }
            } else if (originalUpperBound.length == 1 && (upperBound = Util.resolve(context, contextRawType, originalUpperBound[0], visitedTypeVariables)) != originalUpperBound[0]) {
                return Types.subtypeOf(upperBound);
            }
            return original;
        }
        return toResolve;
    }

    static Type resolveTypeVariable(Type context, Class<?> contextRawType, TypeVariable<?> unknown) {
        Class<?> declaredByRaw = Util.declaringClassOf(unknown);
        if (declaredByRaw == null) {
            return unknown;
        }
        Type declaredBy = Util.getGenericSupertype(context, contextRawType, declaredByRaw);
        if (declaredBy instanceof ParameterizedType) {
            int index = Util.indexOf(declaredByRaw.getTypeParameters(), unknown);
            return ((ParameterizedType)declaredBy).getActualTypeArguments()[index];
        }
        return unknown;
    }

    public static Type getGenericSupertype(Type context, Class<?> rawType, Class<?> toResolve) {
        if (toResolve == rawType) {
            return context;
        }
        if (toResolve.isInterface()) {
            Class<?>[] interfaces = rawType.getInterfaces();
            int length = interfaces.length;
            for (int i = 0; i < length; ++i) {
                if (interfaces[i] == toResolve) {
                    return rawType.getGenericInterfaces()[i];
                }
                if (!toResolve.isAssignableFrom(interfaces[i])) continue;
                return Util.getGenericSupertype(rawType.getGenericInterfaces()[i], interfaces[i], toResolve);
            }
        }
        if (!rawType.isInterface()) {
            while (rawType != Object.class) {
                Class<?> rawSupertype = rawType.getSuperclass();
                if (rawSupertype == toResolve) {
                    return rawType.getGenericSuperclass();
                }
                if (toResolve.isAssignableFrom(rawSupertype)) {
                    return Util.getGenericSupertype(rawType.getGenericSuperclass(), rawSupertype, toResolve);
                }
                rawType = rawSupertype;
            }
        }
        return toResolve;
    }

    static int hashCodeOrZero(@Nullable Object o) {
        return o != null ? o.hashCode() : 0;
    }

    static String typeToString(Type type2) {
        return type2 instanceof Class ? ((Class)type2).getName() : type2.toString();
    }

    static int indexOf(Object[] array, Object toFind) {
        for (int i = 0; i < array.length; ++i) {
            if (!toFind.equals(array[i])) continue;
            return i;
        }
        throw new NoSuchElementException();
    }

    @Nullable
    static Class<?> declaringClassOf(TypeVariable<?> typeVariable) {
        Object genericDeclaration = typeVariable.getGenericDeclaration();
        return genericDeclaration instanceof Class ? (Class)genericDeclaration : null;
    }

    static void checkNotPrimitive(Type type2) {
        if (type2 instanceof Class && ((Class)type2).isPrimitive()) {
            throw new IllegalArgumentException("Unexpected primitive " + type2 + ". Use the boxed type.");
        }
    }

    public static String typeAnnotatedWithAnnotations(Type type2, Set<? extends Annotation> annotations2) {
        return type2 + (annotations2.isEmpty() ? " (with no annotations)" : " annotated " + annotations2);
    }

    @Nullable
    public static JsonAdapter<?> generatedAdapter(Moshi moshi, Type type2, Class<?> rawType) {
        JsonClass jsonClass = rawType.getAnnotation(JsonClass.class);
        if (jsonClass == null || !jsonClass.generateAdapter()) {
            return null;
        }
        String adapterClassName = Types.generatedJsonAdapterName(rawType.getName());
        Class<?> adapterClass = null;
        try {
            Object[] args2;
            Constructor<?> constructor;
            adapterClass = Class.forName(adapterClassName, true, rawType.getClassLoader());
            if (type2 instanceof ParameterizedType) {
                Type[] typeArgs = ((ParameterizedType)type2).getActualTypeArguments();
                try {
                    constructor = adapterClass.getDeclaredConstructor(Moshi.class, Type[].class);
                    args2 = new Object[]{moshi, typeArgs};
                }
                catch (NoSuchMethodException e) {
                    constructor = adapterClass.getDeclaredConstructor(Type[].class);
                    args2 = new Object[]{typeArgs};
                }
            } else {
                try {
                    constructor = adapterClass.getDeclaredConstructor(Moshi.class);
                    args2 = new Object[]{moshi};
                }
                catch (NoSuchMethodException e) {
                    constructor = adapterClass.getDeclaredConstructor(new Class[0]);
                    args2 = new Object[]{};
                }
            }
            constructor.setAccessible(true);
            return ((JsonAdapter)constructor.newInstance(args2)).nullSafe();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Failed to find the generated JsonAdapter class for " + type2, e);
        }
        catch (NoSuchMethodException e) {
            if (!(type2 instanceof ParameterizedType) && adapterClass.getTypeParameters().length != 0) {
                throw new RuntimeException("Failed to find the generated JsonAdapter constructor for '" + type2 + "'. Suspiciously, the type was not parameterized but the target class '" + adapterClass.getCanonicalName() + "' is generic. Consider using Types#newParameterizedType() to define these missing type variables.", e);
            }
            throw new RuntimeException("Failed to find the generated JsonAdapter constructor for " + type2, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to access the generated JsonAdapter for " + type2, e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Failed to instantiate the generated JsonAdapter for " + type2, e);
        }
        catch (InvocationTargetException e) {
            throw Util.rethrowCause(e);
        }
    }

    public static boolean isKotlin(Class<?> targetClass) {
        return METADATA != null && targetClass.isAnnotationPresent(METADATA);
    }

    public static <T> Constructor<T> lookupDefaultsConstructor(Class<T> targetClass) {
        if (DEFAULT_CONSTRUCTOR_MARKER == null) {
            throw new IllegalStateException("DefaultConstructorMarker not on classpath. Make sure the Kotlin stdlib is on the classpath.");
        }
        Constructor<T> defaultConstructor = Util.findConstructor(targetClass);
        defaultConstructor.setAccessible(true);
        return defaultConstructor;
    }

    private static <T> Constructor<T> findConstructor(Class<T> targetClass) {
        for (Constructor<?> constructor : targetClass.getDeclaredConstructors()) {
            Class<?>[] paramTypes = constructor.getParameterTypes();
            if (paramTypes.length == 0 || !paramTypes[paramTypes.length - 1].equals(DEFAULT_CONSTRUCTOR_MARKER)) continue;
            return constructor;
        }
        throw new IllegalStateException("No defaults constructor found for " + targetClass);
    }

    public static JsonDataException missingProperty(String propertyName, String jsonName, JsonReader reader) {
        String path = reader.getPath();
        String message = jsonName.equals(propertyName) ? String.format("Required value '%s' missing at %s", propertyName, path) : String.format("Required value '%s' (JSON name '%s') missing at %s", propertyName, jsonName, path);
        return new JsonDataException(message);
    }

    public static JsonDataException unexpectedNull(String propertyName, String jsonName, JsonReader reader) {
        String path = reader.getPath();
        String message = jsonName.equals(propertyName) ? String.format("Non-null value '%s' was null at %s", propertyName, path) : String.format("Non-null value '%s' (JSON name '%s') was null at %s", propertyName, jsonName, path);
        return new JsonDataException(message);
    }

    public static <T> Class<T> boxIfPrimitive(Class<T> type2) {
        Class<?> wrapped = PRIMITIVE_TO_WRAPPER_TYPE.get(type2);
        return wrapped == null ? type2 : wrapped;
    }

    static {
        Class<?> metadata2 = null;
        try {
            metadata2 = Class.forName(Util.getKotlinMetadataClassName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        METADATA = metadata2;
        Class<?> defaultConstructorMarker = null;
        try {
            defaultConstructorMarker = Class.forName("kotlin.jvm.internal.DefaultConstructorMarker");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        DEFAULT_CONSTRUCTOR_MARKER = defaultConstructorMarker;
        LinkedHashMap<Class<Object>, Class<Void>> primToWrap = new LinkedHashMap<Class<Object>, Class<Void>>(16);
        primToWrap.put(Boolean.TYPE, Boolean.class);
        primToWrap.put(Byte.TYPE, Byte.class);
        primToWrap.put(Character.TYPE, Character.class);
        primToWrap.put(Double.TYPE, Double.class);
        primToWrap.put(Float.TYPE, Float.class);
        primToWrap.put(Integer.TYPE, Integer.class);
        primToWrap.put(Long.TYPE, Long.class);
        primToWrap.put(Short.TYPE, Short.class);
        primToWrap.put(Void.TYPE, Void.class);
        PRIMITIVE_TO_WRAPPER_TYPE = Collections.unmodifiableMap(primToWrap);
    }

    public static final class GenericArrayTypeImpl
    implements GenericArrayType {
        private final Type componentType;

        public GenericArrayTypeImpl(Type componentType) {
            this.componentType = Util.canonicalize(componentType);
        }

        @Override
        public Type getGenericComponentType() {
            return this.componentType;
        }

        public boolean equals(Object o) {
            return o instanceof GenericArrayType && Types.equals(this, (GenericArrayType)o);
        }

        public int hashCode() {
            return this.componentType.hashCode();
        }

        public String toString() {
            return Util.typeToString(this.componentType) + "[]";
        }
    }

    public static final class ParameterizedTypeImpl
    implements ParameterizedType {
        @Nullable
        private final Type ownerType;
        private final Type rawType;
        public final Type[] typeArguments;

        public ParameterizedTypeImpl(@Nullable Type ownerType, Type rawType, Type ... typeArguments) {
            if (rawType instanceof Class) {
                Class<?> enclosingClass = ((Class)rawType).getEnclosingClass();
                if (ownerType != null) {
                    if (enclosingClass == null || Types.getRawType(ownerType) != enclosingClass) {
                        throw new IllegalArgumentException("unexpected owner type for " + rawType + ": " + ownerType);
                    }
                } else if (enclosingClass != null) {
                    throw new IllegalArgumentException("unexpected owner type for " + rawType + ": null");
                }
            }
            this.ownerType = ownerType == null ? null : Util.canonicalize(ownerType);
            this.rawType = Util.canonicalize(rawType);
            this.typeArguments = (Type[])typeArguments.clone();
            for (int t = 0; t < this.typeArguments.length; ++t) {
                if (this.typeArguments[t] == null) {
                    throw new NullPointerException();
                }
                Util.checkNotPrimitive(this.typeArguments[t]);
                this.typeArguments[t] = Util.canonicalize(this.typeArguments[t]);
            }
        }

        @Override
        public Type[] getActualTypeArguments() {
            return (Type[])this.typeArguments.clone();
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }

        @Override
        @Nullable
        public Type getOwnerType() {
            return this.ownerType;
        }

        public boolean equals(Object other) {
            return other instanceof ParameterizedType && Types.equals(this, (ParameterizedType)other);
        }

        public int hashCode() {
            return Arrays.hashCode(this.typeArguments) ^ this.rawType.hashCode() ^ Util.hashCodeOrZero(this.ownerType);
        }

        public String toString() {
            StringBuilder result2 = new StringBuilder(30 * (this.typeArguments.length + 1));
            result2.append(Util.typeToString(this.rawType));
            if (this.typeArguments.length == 0) {
                return result2.toString();
            }
            result2.append("<").append(Util.typeToString(this.typeArguments[0]));
            for (int i = 1; i < this.typeArguments.length; ++i) {
                result2.append(", ").append(Util.typeToString(this.typeArguments[i]));
            }
            return result2.append(">").toString();
        }
    }

    public static final class WildcardTypeImpl
    implements WildcardType {
        private final Type upperBound;
        @Nullable
        private final Type lowerBound;

        public WildcardTypeImpl(Type[] upperBounds2, Type[] lowerBounds) {
            if (lowerBounds.length > 1) {
                throw new IllegalArgumentException();
            }
            if (upperBounds2.length != 1) {
                throw new IllegalArgumentException();
            }
            if (lowerBounds.length == 1) {
                if (lowerBounds[0] == null) {
                    throw new NullPointerException();
                }
                Util.checkNotPrimitive(lowerBounds[0]);
                if (upperBounds2[0] != Object.class) {
                    throw new IllegalArgumentException();
                }
                this.lowerBound = Util.canonicalize(lowerBounds[0]);
                this.upperBound = Object.class;
            } else {
                if (upperBounds2[0] == null) {
                    throw new NullPointerException();
                }
                Util.checkNotPrimitive(upperBounds2[0]);
                this.lowerBound = null;
                this.upperBound = Util.canonicalize(upperBounds2[0]);
            }
        }

        @Override
        public Type[] getUpperBounds() {
            return new Type[]{this.upperBound};
        }

        @Override
        public Type[] getLowerBounds() {
            Type[] typeArray;
            if (this.lowerBound != null) {
                Type[] typeArray2 = new Type[1];
                typeArray = typeArray2;
                typeArray2[0] = this.lowerBound;
            } else {
                typeArray = EMPTY_TYPE_ARRAY;
            }
            return typeArray;
        }

        public boolean equals(Object other) {
            return other instanceof WildcardType && Types.equals(this, (WildcardType)other);
        }

        public int hashCode() {
            return (this.lowerBound != null ? 31 + this.lowerBound.hashCode() : 1) ^ 31 + this.upperBound.hashCode();
        }

        public String toString() {
            if (this.lowerBound != null) {
                return "? super " + Util.typeToString(this.lowerBound);
            }
            if (this.upperBound == Object.class) {
                return "?";
            }
            return "? extends " + Util.typeToString(this.upperBound);
        }
    }
}

