/*
 * Decompiled with CFR 0.152.
 */
package build.buf.connect.protocols;

import build.buf.connect.Code;
import build.buf.connect.Codec;
import build.buf.connect.ConnectError;
import build.buf.connect.ConnectErrorDetail;
import build.buf.connect.ErrorDetailParser;
import build.buf.connect.Idempotency;
import build.buf.connect.Interceptor;
import build.buf.connect.MethodSpec;
import build.buf.connect.ProtocolClientConfig;
import build.buf.connect.RequestCompression;
import build.buf.connect.SerializationStrategy;
import build.buf.connect.StreamFunction;
import build.buf.connect.StreamResult;
import build.buf.connect.UnaryFunction;
import build.buf.connect.compression.CompressionPool;
import build.buf.connect.http.HTTPRequest;
import build.buf.connect.http.HTTPResponse;
import build.buf.connect.http.TracingInfo;
import build.buf.connect.protocols.ConnectInterceptor;
import build.buf.connect.protocols.ConnectInterceptorKt;
import build.buf.connect.protocols.EndStreamResponseJSON;
import build.buf.connect.protocols.Envelope;
import build.buf.connect.protocols.ErrorDetailPayloadJSON;
import build.buf.connect.protocols.ErrorPayloadJSON;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.kotlin.reflect.KotlinJsonAdapterFactory;
import java.io.Closeable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okio.Buffer;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u00142\u0006\u0010\u0015\u001a\u00020\u0010H\u0002J8\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u001c\u0010\u001a\u001a\u0018\u0012\u0004\u0012\u00020\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u001d0\u001bj\u0002`\u001e2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0010H\u0002J\u0018\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u001d2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002J\u0018\u0010#\u001a\u00020$2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020(H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lbuild/buf/connect/protocols/ConnectInterceptor;", "Lbuild/buf/connect/Interceptor;", "clientConfig", "Lbuild/buf/connect/ProtocolClientConfig;", "(Lbuild/buf/connect/ProtocolClientConfig;)V", "moshi", "Lcom/squareup/moshi/Moshi;", "kotlin.jvm.PlatformType", "responseCompressionPool", "Lbuild/buf/connect/compression/CompressionPool;", "serializationStrategy", "Lbuild/buf/connect/SerializationStrategy;", "constructGETRequest", "Lbuild/buf/connect/http/HTTPRequest;", "request", "finalRequestBody", "Lokio/Buffer;", "requestCompression", "Lbuild/buf/connect/RequestCompression;", "parseConnectEndStream", "Lbuild/buf/connect/StreamResult$Complete;", "source", "parseConnectUnaryError", "Lbuild/buf/connect/ConnectError;", "code", "Lbuild/buf/connect/Code;", "headers", "", "", "", "Lbuild/buf/connect/Headers;", "parseErrorDetails", "Lbuild/buf/connect/ConnectErrorDetail;", "jsonClass", "Lbuild/buf/connect/protocols/ErrorPayloadJSON;", "shouldUseGETRequest", "", "streamFunction", "Lbuild/buf/connect/StreamFunction;", "unaryFunction", "Lbuild/buf/connect/UnaryFunction;", "library"})
public final class ConnectInterceptor
implements Interceptor {
    @NotNull
    private final ProtocolClientConfig clientConfig;
    private final Moshi moshi;
    @NotNull
    private final SerializationStrategy serializationStrategy;
    @Nullable
    private CompressionPool responseCompressionPool;

    public ConnectInterceptor(@NotNull ProtocolClientConfig clientConfig) {
        Intrinsics.checkNotNullParameter(clientConfig, "clientConfig");
        this.clientConfig = clientConfig;
        this.moshi = new Moshi.Builder().add(new KotlinJsonAdapterFactory()).build();
        this.serializationStrategy = this.clientConfig.getSerializationStrategy();
    }

    @Override
    @NotNull
    public UnaryFunction unaryFunction() {
        return new UnaryFunction((Function1<? super HTTPRequest, HTTPRequest>)new Function1<HTTPRequest, HTTPRequest>(this){
            final /* synthetic */ ConnectInterceptor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final HTTPRequest invoke(@NotNull HTTPRequest request) {
                Buffer buffer;
                Intrinsics.checkNotNullParameter(request, "request");
                Object object = new Pair[]{TuplesKt.to("connect-protocol-version", CollectionsKt.listOf("1"))};
                Map<String, List<String>> requestHeaders = MapsKt.mutableMapOf(object);
                requestHeaders.putAll(request.getHeaders());
                if (!((Collection)ConnectInterceptor.access$getClientConfig$p(this.this$0).compressionPools()).isEmpty()) {
                    Collection<String> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    object = ConnectInterceptor.access$getClientConfig$p(this.this$0).compressionPools();
                    String string = "accept-encoding";
                    Map<String, List<String>> map2 = requestHeaders;
                    boolean $i$f$map = false;
                    void var5_8 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void compressionPool;
                        CompressionPool compressionPool2 = (CompressionPool)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(compressionPool.name());
                    }
                    collection = (List)destination$iv$iv;
                    map2.put(string, (List<String>)collection);
                }
                RequestCompression requestCompression = ConnectInterceptor.access$getClientConfig$p(this.this$0).getRequestCompression();
                Buffer requestMessage = new Buffer();
                if (request.getMessage() != null) {
                    requestMessage.write(request.getMessage());
                }
                RequestCompression requestCompression2 = requestCompression;
                if (requestCompression2 == null ? false : requestCompression2.shouldCompress(requestMessage)) {
                    requestHeaders.put("content-encoding", CollectionsKt.listOf(requestCompression.getCompressionPool().name()));
                    buffer = requestCompression.getCompressionPool().compress(requestMessage);
                } else {
                    buffer = requestMessage;
                }
                Buffer finalRequestBody = buffer;
                return ConnectInterceptor.access$shouldUseGETRequest(this.this$0, request, finalRequestBody) ? ConnectInterceptor.access$constructGETRequest(this.this$0, request, finalRequestBody, requestCompression) : request.clone(request.getUrl(), request.getContentType(), requestHeaders, finalRequestBody.readByteArray(), request.getMethodSpec());
            }
        }, (Function1<? super HTTPResponse, HTTPResponse>)new Function1<HTTPResponse, HTTPResponse>(this){
            final /* synthetic */ ConnectInterceptor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final HTTPResponse invoke(@NotNull HTTPResponse response) {
                ConnectError connectError;
                Buffer message;
                Pair<Code, Object> pair;
                void $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter(response, "response");
                Map trailers = new LinkedHashMap<K, V>();
                trailers.putAll(ConnectInterceptorKt.access$toTrailers(response.getHeaders()));
                trailers.putAll(response.getTrailers());
                Map<String, List<String>> $this$filter$iv = response.getHeaders();
                boolean $i$f$filter = false;
                Map<String, List<String>> map2 = $this$filter$iv;
                Map destination$iv$iv = new LinkedHashMap<K, V>();
                boolean $i$f$filterTo = false;
                Object object = $this$filterTo$iv$iv.entrySet().iterator();
                while (object.hasNext()) {
                    Map.Entry<K, V> element$iv$iv;
                    Map.Entry<K, V> entry = element$iv$iv = object.next();
                    boolean bl = false;
                    if (!(!StringsKt.startsWith$default((String)entry.getKey(), "trailer", false, 2, null))) continue;
                    destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                }
                Map<K, V> responseHeaders = MapsKt.toMutableMap(destination$iv$iv);
                List list = (List)responseHeaders.get("content-encoding");
                CompressionPool compressionPool = ConnectInterceptor.access$getClientConfig$p(this.this$0).compressionPool(list == null ? null : (String)CollectionsKt.first(list));
                if (response.getCode() != Code.OK) {
                    ConnectError error = ConnectInterceptor.access$parseConnectUnaryError(this.this$0, response.getCode(), response.getHeaders(), response.getMessage().getBuffer());
                    pair = TuplesKt.to(error.getCode(), error);
                } else {
                    pair = TuplesKt.to(response.getCode(), null);
                }
                Pair<Code, Object> pair2 = pair;
                Code code = pair2.component1();
                ConnectError connectError2 = pair2.component2();
                CompressionPool compressionPool2 = compressionPool;
                Buffer buffer = compressionPool2 == null ? null : compressionPool2.decompress(response.getMessage().getBuffer());
                if (buffer == null) {
                    buffer = message = response.getMessage().getBuffer();
                }
                if ((connectError = response.getError()) == null) {
                    connectError = connectError2;
                }
                object = connectError;
                TracingInfo tracingInfo = response.getTracingInfo();
                return new HTTPResponse(code, responseHeaders, message, trailers, tracingInfo, (ConnectError)object);
            }
        });
    }

    @Override
    @NotNull
    public StreamFunction streamFunction() {
        RequestCompression requestCompression = this.clientConfig.getRequestCompression();
        return new StreamFunction((Function1<? super HTTPRequest, HTTPRequest>)new Function1<HTTPRequest, HTTPRequest>(requestCompression, this){
            final /* synthetic */ RequestCompression $requestCompression;
            final /* synthetic */ ConnectInterceptor this$0;
            {
                this.$requestCompression = $requestCompression;
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final HTTPRequest invoke(@NotNull HTTPRequest request) {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter(request, "request");
                Object object = new Pair[]{TuplesKt.to("connect-protocol-version", CollectionsKt.listOf("1"))};
                Map<String, List> requestHeaders = MapsKt.mutableMapOf(object);
                requestHeaders.putAll(request.getHeaders());
                if (this.$requestCompression != null) {
                    requestHeaders.put("connect-content-encoding", CollectionsKt.listOf(this.$requestCompression.getCompressionPool().name()));
                }
                object = ConnectInterceptor.access$getClientConfig$p(this.this$0).compressionPools();
                String string = "connect-accept-encoding";
                Map<String, List> map2 = requestHeaders;
                boolean $i$f$map = false;
                void var5_7 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void entry;
                    CompressionPool compressionPool = (CompressionPool)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(entry.name());
                }
                collection = (List)destination$iv$iv;
                map2.put(string, (List)collection);
                return request.clone(request.getUrl(), request.getContentType(), requestHeaders, request.getMessage(), request.getMethodSpec());
            }
        }, (Function1<? super Buffer, Buffer>)new Function1<Buffer, Buffer>(requestCompression){
            final /* synthetic */ RequestCompression $requestCompression;
            {
                this.$requestCompression = $requestCompression;
                super(1);
            }

            @NotNull
            public final Buffer invoke(@NotNull Buffer buffer) {
                Intrinsics.checkNotNullParameter(buffer, "buffer");
                RequestCompression requestCompression = this.$requestCompression;
                CompressionPool compressionPool = requestCompression == null ? null : requestCompression.getCompressionPool();
                RequestCompression requestCompression2 = this.$requestCompression;
                return Envelope.Companion.pack(buffer, compressionPool, requestCompression2 == null ? null : Integer.valueOf(requestCompression2.getMinBytes()));
            }
        }, (Function1<? super StreamResult<Buffer>, ? extends StreamResult<Buffer>>)new Function1<StreamResult<Buffer>, StreamResult<Buffer>>(this){
            final /* synthetic */ ConnectInterceptor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final StreamResult<Buffer> invoke(@NotNull StreamResult<Buffer> res) {
                Intrinsics.checkNotNullParameter(res, "res");
                StreamResult streamResult2 = (StreamResult)res.fold((Function1)new Function1<StreamResult.Headers<Buffer>, StreamResult<Buffer>>(this.this$0){
                    final /* synthetic */ ConnectInterceptor this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final StreamResult<Buffer> invoke(@NotNull StreamResult.Headers<Buffer> result2) {
                        void $this$filterTo$iv$iv;
                        Intrinsics.checkNotNullParameter(result2, "result");
                        Map<String, List<String>> $this$filter$iv = result2.getHeaders();
                        boolean $i$f$filter = false;
                        Map<String, List<String>> map2 = $this$filter$iv;
                        Map destination$iv$iv = new LinkedHashMap<K, V>();
                        boolean $i$f$filterTo = false;
                        Iterator<Map.Entry<K, V>> iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
                        while (iterator2.hasNext()) {
                            Map.Entry<K, V> element$iv$iv;
                            Map.Entry<K, V> entry = element$iv$iv = iterator2.next();
                            boolean bl = false;
                            if (!(!StringsKt.startsWith$default((String)entry.getKey(), "trailer", false, 2, null))) continue;
                            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                        }
                        Map<K, V> responseHeaders = MapsKt.toMutableMap(destination$iv$iv);
                        List list = (List)responseHeaders.get("connect-content-encoding");
                        ConnectInterceptor.access$setResponseCompressionPool$p(this.this$0, ConnectInterceptor.access$getClientConfig$p(this.this$0).compressionPool(list == null ? null : (String)CollectionsKt.first(list)));
                        return new StreamResult.Headers<Output>(responseHeaders);
                    }
                }, (Function1)new Function1<StreamResult.Message<Buffer>, StreamResult<Buffer>>(this.this$0){
                    final /* synthetic */ ConnectInterceptor this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final StreamResult<Buffer> invoke(@NotNull StreamResult.Message<Buffer> result2) {
                        Intrinsics.checkNotNullParameter(result2, "result");
                        Pair<Integer, Buffer> pair = Envelope.Companion.unpackWithHeaderByte(result2.getMessage(), ConnectInterceptor.access$getResponseCompressionPool$p(this.this$0));
                        int headerByte = ((Number)pair.component1()).intValue();
                        Buffer unpackedMessage = pair.component2();
                        boolean isEndStream = (headerByte >> 1 & 1) == 1;
                        return isEndStream ? (StreamResult)ConnectInterceptor.access$parseConnectEndStream(this.this$0, unpackedMessage) : (StreamResult)new StreamResult.Message<Buffer>(unpackedMessage);
                    }
                }, streamFunction.streamResult.3.INSTANCE);
                return streamResult2;
            }
        });
    }

    private final boolean shouldUseGETRequest(HTTPRequest request, Buffer finalRequestBody) {
        return request.getMethodSpec().getIdempotency() == Idempotency.NO_SIDE_EFFECTS && this.clientConfig.getGetConfiguration().useGET(finalRequestBody);
    }

    private final HTTPRequest constructGETRequest(HTTPRequest request, Buffer finalRequestBody, RequestCompression requestCompression) {
        SerializationStrategy serializationStrategy = this.clientConfig.getSerializationStrategy();
        Codec<?> requestCodec = serializationStrategy.codec(request.getMethodSpec().getRequestClass());
        URL url = ConnectInterceptorKt.access$getUrlFromMethodSpec(request, requestCodec, finalRequestBody, requestCompression);
        return HTTPRequest.clone$default(request, url, Intrinsics.stringPlus("application/", requestCodec.encodingName()), request.getHeaders(), null, new MethodSpec(request.getMethodSpec().getPath(), request.getMethodSpec().getRequestClass(), request.getMethodSpec().getResponseClass(), request.getMethodSpec().getIdempotency(), "GET"), 8, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final StreamResult.Complete<Buffer> parseConnectEndStream(Buffer source2) {
        StreamResult.Complete<Buffer> complete;
        JsonAdapter<EndStreamResponseJSON> adapter = this.moshi.adapter(EndStreamResponseJSON.class);
        Closeable closeable = source2;
        Throwable throwable = null;
        try {
            Map<String, Map.Entry> map2;
            EndStreamResponseJSON endStreamResponseJSON;
            block17: {
                Buffer bufferedSource = (Buffer)closeable;
                boolean bl = false;
                String errorJSON = bufferedSource.readUtf8();
                try {
                    if (adapter.fromJson(errorJSON) != null) break block17;
                    StreamResult.Complete<Buffer> complete2 = new StreamResult.Complete<Buffer>(Code.OK, null, null, 6, null);
                    return complete2;
                }
                catch (Throwable e) {
                    StreamResult.Complete<Buffer> complete3 = new StreamResult.Complete<Buffer>(Code.UNKNOWN, e, null, 4, null);
                    CloseableKt.closeFinally(closeable, throwable);
                    return complete3;
                }
            }
            EndStreamResponseJSON endStreamResponseJSON2 = endStreamResponseJSON;
            EndStreamResponseJSON endStreamResponseJSON3 = endStreamResponseJSON2;
            Map<String, List<String>> map3 = endStreamResponseJSON3.getMetadata();
            if (map3 == null) {
                map2 = null;
            } else {
                void $this$mapKeysTo$iv$iv;
                Map<String, List<String>> $this$mapKeys$iv = map3;
                boolean $i$f$mapKeys = false;
                Map<String, List<String>> map4 = $this$mapKeys$iv;
                Map<String, Map.Entry> destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($this$mapKeys$iv.size()));
                boolean $i$f$mapKeysTo = false;
                Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    void it$iv$iv;
                    void entry;
                    Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                    Map<String, Map.Entry> map5 = destination$iv$iv;
                    boolean bl = false;
                    String string = ((String)entry.getKey()).toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).toLowerCase(Locale.ROOT)");
                    Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
                    String string2 = string;
                    Map<String, Map.Entry> map6 = map5;
                    boolean bl2 = false;
                    entry2 = it$iv$iv.getValue();
                    map6.put(string2, entry2);
                }
                map2 = destination$iv$iv;
            }
            Map<String, Map.Entry> metadata2 = map2;
            ErrorPayloadJSON errorPayloadJSON = endStreamResponseJSON3.getError();
            if ((errorPayloadJSON == null ? null : errorPayloadJSON.getCode()) == null) {
                Map<String, Map.Entry> map7 = metadata2;
                if (map7 == null) {
                    map7 = MapsKt.emptyMap();
                }
                StreamResult.Complete<Buffer> complete4 = new StreamResult.Complete<Buffer>(Code.OK, null, map7, 2, null);
                return complete4;
            }
            Code code = Code.Companion.fromName(endStreamResponseJSON3.getError().getCode());
            ErrorDetailParser errorDetailParser = this.serializationStrategy.errorDetailParser();
            String string = endStreamResponseJSON3.getError().getMessage();
            List<ConnectErrorDetail> list = this.parseErrorDetails(endStreamResponseJSON3.getError());
            Map<String, Map.Entry> map8 = metadata2;
            if (map8 == null) {
                map8 = MapsKt.emptyMap();
            }
            complete = new StreamResult.Complete<Buffer>(code, new ConnectError(code, errorDetailParser, string, null, list, map8, 8, null), null, 4, null);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        return complete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ConnectError parseConnectUnaryError(Code code, Map<String, ? extends List<String>> headers, Buffer source2) {
        ConnectError connectError;
        if (source2 == null) {
            return new ConnectError(code, this.serializationStrategy.errorDetailParser(), "empty error message from source", null, null, null, 56, null);
        }
        Closeable closeable = source2;
        Throwable throwable = null;
        try {
            ErrorPayloadJSON errorPayloadJSON;
            block11: {
                Buffer bufferedSource = (Buffer)closeable;
                boolean bl = false;
                JsonAdapter<ErrorPayloadJSON> adapter = this.moshi.adapter(ErrorPayloadJSON.class);
                String errorJSON = bufferedSource.readUtf8();
                try {
                    if (adapter.fromJson(errorJSON) != null) break block11;
                    ConnectError connectError2 = new ConnectError(code, this.serializationStrategy.errorDetailParser(), errorJSON, null, null, null, 56, null);
                    return connectError2;
                }
                catch (Throwable e) {
                    ConnectError connectError3 = new ConnectError(code, this.serializationStrategy.errorDetailParser(), errorJSON, null, null, null, 56, null);
                    CloseableKt.closeFinally(closeable, throwable);
                    return connectError3;
                }
            }
            ErrorPayloadJSON errorPayloadJSON2 = errorPayloadJSON;
            ErrorPayloadJSON errorPayloadJSON3 = errorPayloadJSON2;
            List<ConnectErrorDetail> errorDetails = this.parseErrorDetails(errorPayloadJSON3);
            connectError = new ConnectError(Code.Companion.fromName(errorPayloadJSON3.getCode()), this.serializationStrategy.errorDetailParser(), errorPayloadJSON3.getMessage(), null, errorDetails, headers, 8, null);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        return connectError;
    }

    private final List<ConnectErrorDetail> parseErrorDetails(ErrorPayloadJSON jsonClass) {
        List errorDetails = new ArrayList();
        ErrorPayloadJSON errorPayloadJSON = jsonClass;
        List<ErrorDetailPayloadJSON> list = errorPayloadJSON == null ? null : errorPayloadJSON.getDetails();
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        for (ErrorDetailPayloadJSON detail : list) {
            if (detail.getType() == null) continue;
            String payload = detail.getValue();
            if (payload == null) {
                errorDetails.add(new ConnectErrorDetail(detail.getType(), ByteString.EMPTY));
                continue;
            }
            errorDetails.add(new ConnectErrorDetail(detail.getType(), ByteString.Companion.encodeUtf8(payload)));
        }
        return errorDetails;
    }

    public static final /* synthetic */ ProtocolClientConfig access$getClientConfig$p(ConnectInterceptor $this) {
        return $this.clientConfig;
    }

    public static final /* synthetic */ boolean access$shouldUseGETRequest(ConnectInterceptor $this, HTTPRequest request, Buffer finalRequestBody) {
        return $this.shouldUseGETRequest(request, finalRequestBody);
    }

    public static final /* synthetic */ HTTPRequest access$constructGETRequest(ConnectInterceptor $this, HTTPRequest request, Buffer finalRequestBody, RequestCompression requestCompression) {
        return $this.constructGETRequest(request, finalRequestBody, requestCompression);
    }

    public static final /* synthetic */ ConnectError access$parseConnectUnaryError(ConnectInterceptor $this, Code code, Map headers, Buffer source2) {
        return $this.parseConnectUnaryError(code, headers, source2);
    }

    public static final /* synthetic */ void access$setResponseCompressionPool$p(ConnectInterceptor $this, CompressionPool compressionPool) {
        $this.responseCompressionPool = compressionPool;
    }

    public static final /* synthetic */ CompressionPool access$getResponseCompressionPool$p(ConnectInterceptor $this) {
        return $this.responseCompressionPool;
    }

    public static final /* synthetic */ StreamResult.Complete access$parseConnectEndStream(ConnectInterceptor $this, Buffer source2) {
        return $this.parseConnectEndStream(source2);
    }
}

