/*
 * Decompiled with CFR 0.152.
 */
package build.buf.connect.protocols;

import build.buf.connect.Code;
import build.buf.connect.ConnectError;
import build.buf.connect.ConnectErrorDetail;
import build.buf.connect.ErrorDetailParser;
import build.buf.connect.Interceptor;
import build.buf.connect.ProtocolClientConfig;
import build.buf.connect.RequestCompression;
import build.buf.connect.SerializationStrategy;
import build.buf.connect.StreamFunction;
import build.buf.connect.StreamResult;
import build.buf.connect.UnaryFunction;
import build.buf.connect.compression.CompressionPool;
import build.buf.connect.http.HTTPRequest;
import build.buf.connect.http.HTTPResponse;
import build.buf.connect.http.TracingInfo;
import build.buf.connect.protocols.Envelope;
import build.buf.connect.protocols.GRPCCompletion;
import build.buf.connect.protocols.GRPCCompletionParser;
import build.buf.connect.protocols.GRPCWebInterceptor;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okio.Buffer;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u000b\u001a\u0018\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u000e0\fj\u0002`\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J8\u0010\u0016\u001a\u0018\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u000e0\fj\u0002`\u0017*\u0018\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u000e0\fj\u0002`\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lbuild/buf/connect/protocols/GRPCWebInterceptor;", "Lbuild/buf/connect/Interceptor;", "clientConfig", "Lbuild/buf/connect/ProtocolClientConfig;", "(Lbuild/buf/connect/ProtocolClientConfig;)V", "completionParser", "Lbuild/buf/connect/protocols/GRPCCompletionParser;", "responseCompressionPool", "Lbuild/buf/connect/compression/CompressionPool;", "serializationStrategy", "Lbuild/buf/connect/SerializationStrategy;", "parseGrpcWebTrailer", "", "", "", "Lbuild/buf/connect/Trailers;", "buffer", "Lokio/Buffer;", "streamFunction", "Lbuild/buf/connect/StreamFunction;", "unaryFunction", "Lbuild/buf/connect/UnaryFunction;", "withGRPCRequestHeaders", "Lbuild/buf/connect/Headers;", "library"})
public final class GRPCWebInterceptor
implements Interceptor {
    @NotNull
    private final ProtocolClientConfig clientConfig;
    @NotNull
    private final SerializationStrategy serializationStrategy;
    @NotNull
    private final GRPCCompletionParser completionParser;
    @Nullable
    private CompressionPool responseCompressionPool;

    public GRPCWebInterceptor(@NotNull ProtocolClientConfig clientConfig) {
        Intrinsics.checkNotNullParameter(clientConfig, "clientConfig");
        this.clientConfig = clientConfig;
        this.serializationStrategy = this.clientConfig.getSerializationStrategy();
        this.completionParser = new GRPCCompletionParser(this.serializationStrategy.errorDetailParser());
    }

    @Override
    @NotNull
    public UnaryFunction unaryFunction() {
        return new UnaryFunction((Function1<? super HTTPRequest, HTTPRequest>)new Function1<HTTPRequest, HTTPRequest>(this){
            final /* synthetic */ GRPCWebInterceptor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            @NotNull
            public final HTTPRequest invoke(@NotNull HTTPRequest request) {
                Buffer buffer;
                Closeable $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter(request, "request");
                Map requestHeaders = new LinkedHashMap<K, V>();
                requestHeaders.putAll(request.getHeaders());
                if (!((Collection)GRPCWebInterceptor.access$getClientConfig$p(this.this$0).compressionPools()).isEmpty()) {
                    Collection<String> collection;
                    void $this$map$iv;
                    Iterable iterable = GRPCWebInterceptor.access$getClientConfig$p(this.this$0).compressionPools();
                    String string = "grpc-accept-encoding";
                    Map map2 = requestHeaders;
                    boolean $i$f$map = false;
                    void var5_8 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo = false;
                    Iterator<T> iterator2 = $this$mapTo$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        void compressionPool;
                        T item$iv$iv = iterator2.next();
                        CompressionPool compressionPool2 = (CompressionPool)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(compressionPool.name());
                    }
                    collection = (List)destination$iv$iv;
                    map2.put(string, collection);
                }
                RequestCompression requestCompressionPool = GRPCWebInterceptor.access$getClientConfig$p(this.this$0).getRequestCompression();
                $this$mapTo$iv$iv = new Buffer();
                Throwable throwable = null;
                try {
                    Buffer buffer2 = (Buffer)$this$mapTo$iv$iv;
                    boolean bl = false;
                    if (request.getMessage() != null) {
                        buffer2.write(request.getMessage());
                    }
                    buffer = buffer2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally($this$mapTo$iv$iv, throwable);
                }
                Buffer requestMessage = buffer;
                RequestCompression requestCompression = requestCompressionPool;
                RequestCompression requestCompression2 = requestCompressionPool;
                Buffer envelopedMessage = Envelope.Companion.pack(requestMessage, (CompressionPool)(requestCompression == null ? null : requestCompression.getCompressionPool()), requestCompression2 == null ? null : Integer.valueOf(requestCompression2.getMinBytes()));
                return HTTPRequest.clone$default(request, request.getUrl(), Intrinsics.stringPlus("application/grpc-web+", GRPCWebInterceptor.access$getSerializationStrategy$p(this.this$0).serializationName()), GRPCWebInterceptor.access$withGRPCRequestHeaders(this.this$0, requestHeaders), envelopedMessage.readByteArray(), null, 16, null);
            }
        }, (Function1<? super HTTPResponse, HTTPResponse>)new Function1<HTTPResponse, HTTPResponse>(this){
            final /* synthetic */ GRPCWebInterceptor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final HTTPResponse invoke(@NotNull HTTPResponse response) {
                HTTPResponse hTTPResponse;
                Intrinsics.checkNotNullParameter(response, "response");
                if (response.getCode() != Code.OK) {
                    return response;
                }
                Map<String, List<String>> responseHeaders = MapsKt.toMutableMap(response.getHeaders());
                List<String> list = responseHeaders.get("grpc-encoding");
                CompressionPool compressionPool = GRPCWebInterceptor.access$getClientConfig$p(this.this$0).compressionPool(list == null ? null : CollectionsKt.first(list));
                if (response.getMessage().exhausted()) {
                    String string;
                    GRPCCompletion completion;
                    Map<String, List<String>> trailers = response.getHeaders();
                    GRPCCompletion gRPCCompletion = completion = GRPCWebInterceptor.access$getCompletionParser$p(this.this$0).parse$library(trailers);
                    Code code = gRPCCompletion == null ? null : gRPCCompletion.getCode();
                    if (code == null) {
                        code = response.getCode();
                    }
                    Code code2 = code;
                    Buffer result2 = new Buffer();
                    if (completion != null) {
                        ByteString errorMessage2 = completion.getMessage();
                        result2.write(errorMessage2);
                    }
                    ErrorDetailParser errorDetailParser = GRPCWebInterceptor.access$getSerializationStrategy$p(this.this$0).errorDetailParser();
                    GRPCCompletion gRPCCompletion2 = completion;
                    if (gRPCCompletion2 == null) {
                        string = null;
                    } else {
                        ByteString byteString = gRPCCompletion2.getMessage();
                        string = byteString == null ? null : byteString.utf8();
                    }
                    GRPCCompletion gRPCCompletion3 = completion;
                    List<ConnectErrorDetail> list2 = gRPCCompletion3 == null ? null : gRPCCompletion3.getErrorDetails();
                    if (list2 == null) {
                        list2 = CollectionsKt.emptyList();
                    }
                    ConnectError connectError = new ConnectError(code2, errorDetailParser, string, null, list2, null, 40, null);
                    TracingInfo tracingInfo = response.getTracingInfo();
                    hTTPResponse = new HTTPResponse(code2, responseHeaders, result2, trailers, tracingInfo, connectError);
                } else {
                    ConnectError connectError;
                    Code finalCode;
                    GRPCCompletion completionWithMessage;
                    Buffer trailerBuffer;
                    Buffer responseBuffer = response.getMessage().getBuffer();
                    Buffer currentMessage = new Buffer();
                    byte header = responseBuffer.readByte();
                    int length = responseBuffer.readInt();
                    currentMessage.writeByte(header);
                    currentMessage.writeInt(length);
                    currentMessage.write(responseBuffer, (long)length);
                    Pair<Integer, Buffer> pair = Envelope.Companion.unpackWithHeaderByte(currentMessage, compressionPool);
                    int headerByte = ((Number)pair.component1()).intValue();
                    Buffer unpacked = pair.component2();
                    Buffer trailerBuffer2 = (headerByte & 0x80) == 128 ? unpacked : (trailerBuffer = Envelope.Companion.unpackWithHeaderByte(responseBuffer, compressionPool).component2());
                    Map finalTrailers = GRPCWebInterceptor.access$parseGrpcWebTrailer(this.this$0, trailerBuffer2);
                    GRPCCompletion gRPCCompletion = completionWithMessage = GRPCWebInterceptor.access$getCompletionParser$p(this.this$0).parse$library(finalTrailers);
                    Code code = gRPCCompletion == null ? null : gRPCCompletion.getCode();
                    if (code == null) {
                        code = Code.UNKNOWN;
                    }
                    if ((finalCode = code) != Code.OK && completionWithMessage != null) {
                        Buffer result3 = new Buffer();
                        ByteString errorMessage3 = completionWithMessage.getMessage();
                        result3.write(errorMessage3);
                        connectError = new ConnectError(finalCode, GRPCWebInterceptor.access$getSerializationStrategy$p(this.this$0).errorDetailParser(), errorMessage3.utf8(), null, completionWithMessage.getErrorDetails(), null, 40, null);
                    } else {
                        connectError = null;
                    }
                    ConnectError error = connectError;
                    TracingInfo tracingInfo = response.getTracingInfo();
                    hTTPResponse = new HTTPResponse(finalCode, responseHeaders, unpacked, finalTrailers, tracingInfo, error);
                }
                return hTTPResponse;
            }
        });
    }

    @Override
    @NotNull
    public StreamFunction streamFunction() {
        return new StreamFunction((Function1<? super HTTPRequest, HTTPRequest>)new Function1<HTTPRequest, HTTPRequest>(this){
            final /* synthetic */ GRPCWebInterceptor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final HTTPRequest invoke(@NotNull HTTPRequest request) {
                Intrinsics.checkNotNullParameter(request, "request");
                return HTTPRequest.clone$default(request, request.getUrl(), Intrinsics.stringPlus("application/grpc-web+", GRPCWebInterceptor.access$getSerializationStrategy$p(this.this$0).serializationName()), GRPCWebInterceptor.access$withGRPCRequestHeaders(this.this$0, request.getHeaders()), request.getMessage(), null, 16, null);
            }
        }, (Function1<? super Buffer, Buffer>)new Function1<Buffer, Buffer>(this){
            final /* synthetic */ GRPCWebInterceptor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Buffer invoke(@NotNull Buffer buffer) {
                RequestCompression requestCompression;
                Intrinsics.checkNotNullParameter(buffer, "buffer");
                RequestCompression requestCompression2 = requestCompression = GRPCWebInterceptor.access$getClientConfig$p(this.this$0).getRequestCompression();
                RequestCompression requestCompression3 = requestCompression;
                return Envelope.Companion.pack(buffer, (CompressionPool)(requestCompression2 == null ? null : requestCompression2.getCompressionPool()), requestCompression3 == null ? null : Integer.valueOf(requestCompression3.getMinBytes()));
            }
        }, (Function1<? super StreamResult<Buffer>, ? extends StreamResult<Buffer>>)new Function1<StreamResult<Buffer>, StreamResult<Buffer>>(this){
            final /* synthetic */ GRPCWebInterceptor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final StreamResult<Buffer> invoke(@NotNull StreamResult<Buffer> res) {
                Intrinsics.checkNotNullParameter(res, "res");
                StreamResult streamResult2 = (StreamResult)res.fold((Function1)new Function1<StreamResult.Headers<Buffer>, StreamResult<Buffer>>(this.this$0){
                    final /* synthetic */ GRPCWebInterceptor this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final StreamResult<Buffer> invoke(@NotNull StreamResult.Headers<Buffer> result2) {
                        void $this$filterTo$iv$iv;
                        Intrinsics.checkNotNullParameter(result2, "result");
                        Map<String, List<String>> $this$filter$iv = result2.getHeaders();
                        boolean $i$f$filter = false;
                        Map<String, List<String>> map2 = $this$filter$iv;
                        Map destination$iv$iv = new LinkedHashMap<K, V>();
                        boolean $i$f$filterTo = false;
                        Iterator<Map.Entry<K, V>> iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
                        while (iterator2.hasNext()) {
                            Map.Entry<K, V> element$iv$iv;
                            Map.Entry<K, V> entry = element$iv$iv = iterator2.next();
                            boolean bl = false;
                            if (!(!StringsKt.startsWith$default((String)entry.getKey(), "trailer", false, 2, null))) continue;
                            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                        }
                        Map<K, V> responseHeaders = MapsKt.toMutableMap(destination$iv$iv);
                        List list = (List)responseHeaders.get("grpc-encoding");
                        GRPCWebInterceptor.access$setResponseCompressionPool$p(this.this$0, GRPCWebInterceptor.access$getClientConfig$p(this.this$0).compressionPool(list == null ? null : (String)CollectionsKt.first(list)));
                        Map<K, V> streamTrailers = responseHeaders;
                        GRPCCompletion completion = GRPCWebInterceptor.access$getCompletionParser$p(this.this$0).parse$library(streamTrailers);
                        if (completion != null) {
                            ConnectError error = completion.getCode() != Code.OK ? new ConnectError(completion.getCode(), GRPCWebInterceptor.access$getSerializationStrategy$p(this.this$0).errorDetailParser(), completion.getMessage().utf8(), null, completion.getErrorDetails(), streamTrailers, 8, null) : (ConnectError)null;
                            return new StreamResult.Complete<Output>(completion.getCode(), error, responseHeaders);
                        }
                        return new StreamResult.Headers<Output>(responseHeaders);
                    }
                }, (Function1)new Function1<StreamResult.Message<Buffer>, StreamResult<Buffer>>(this.this$0){
                    final /* synthetic */ GRPCWebInterceptor this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final StreamResult<Buffer> invoke(@NotNull StreamResult.Message<Buffer> result2) {
                        Intrinsics.checkNotNullParameter(result2, "result");
                        Pair<Integer, Buffer> pair = Envelope.Companion.unpackWithHeaderByte(result2.getMessage(), GRPCWebInterceptor.access$getResponseCompressionPool$p(this.this$0));
                        int headerByte = ((Number)pair.component1()).intValue();
                        Buffer unpackedMessage = pair.component2();
                        if ((headerByte & 0x80) == 128) {
                            GRPCCompletion completion;
                            Map streamTrailers = GRPCWebInterceptor.access$parseGrpcWebTrailer(this.this$0, unpackedMessage);
                            GRPCCompletion gRPCCompletion = completion = GRPCWebInterceptor.access$getCompletionParser$p(this.this$0).parse$library(streamTrailers);
                            Intrinsics.checkNotNull(gRPCCompletion);
                            Code code = gRPCCompletion.getCode();
                            ConnectError connectError = result2.connectError() != null ? result2.connectError() : (result2.getError() != null || code != Code.OK ? new ConnectError(code, GRPCWebInterceptor.access$getSerializationStrategy$p(this.this$0).errorDetailParser(), completion.getMessage().utf8(), result2.getError(), completion.getErrorDetails(), streamTrailers) : (ConnectError)null);
                            return new StreamResult.Complete<Output>(code, connectError, streamTrailers);
                        }
                        return new StreamResult.Message<Buffer>(unpackedMessage);
                    }
                }, streamFunction.streamResult.3.INSTANCE);
                return streamResult2;
            }
        });
    }

    private final Map<String, List<String>> withGRPCRequestHeaders(Map<String, ? extends List<String>> $this$withGRPCRequestHeaders) {
        Map<String, List<String>> headers = MapsKt.toMutableMap($this$withGRPCRequestHeaders);
        headers.put("x-user-agent", CollectionsKt.listOf("@bufbuild/connect-kotlin"));
        headers.put("te", CollectionsKt.listOf("trailers"));
        RequestCompression requestCompression = this.clientConfig.getRequestCompression();
        if (requestCompression != null) {
            headers.put("grpc-encoding", CollectionsKt.listOf(requestCompression.getCompressionPool().name()));
        }
        return headers;
    }

    private final Map<String, List<String>> parseGrpcWebTrailer(Buffer buffer) {
        Map trailers = new LinkedHashMap();
        String[] stringArray = new String[]{"\r\n"};
        List lines = StringsKt.split$default((CharSequence)buffer.readUtf8(), stringArray, false, 0, 6, null);
        for (String line : lines) {
            int i;
            if (Intrinsics.areEqual(line, "") || (i = StringsKt.indexOf$default((CharSequence)line, ":", 0, false, 6, null)) <= 0) continue;
            String string = line;
            int n = 0;
            String string2 = string.substring(n, i);
            Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String\u2026ing(startIndex, endIndex)");
            String string3 = ((Object)StringsKt.trim((CharSequence)string2)).toString().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String).toLowerCase(Locale.ROOT)");
            String name = string3;
            string3 = line;
            int n2 = i + 1;
            String string4 = string3.substring(n2);
            Intrinsics.checkNotNullExpressionValue(string4, "this as java.lang.String).substring(startIndex)");
            string2 = ((Object)StringsKt.trim((CharSequence)string4)).toString().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).toLowerCase(Locale.ROOT)");
            String value = string2;
            string2 = name.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).toLowerCase(Locale.ROOT)");
            trailers.put(string2, CollectionsKt.listOf(value));
        }
        return trailers;
    }

    public static final /* synthetic */ ProtocolClientConfig access$getClientConfig$p(GRPCWebInterceptor $this) {
        return $this.clientConfig;
    }

    public static final /* synthetic */ SerializationStrategy access$getSerializationStrategy$p(GRPCWebInterceptor $this) {
        return $this.serializationStrategy;
    }

    public static final /* synthetic */ Map access$withGRPCRequestHeaders(GRPCWebInterceptor $this, Map $receiver) {
        return $this.withGRPCRequestHeaders($receiver);
    }

    public static final /* synthetic */ GRPCCompletionParser access$getCompletionParser$p(GRPCWebInterceptor $this) {
        return $this.completionParser;
    }

    public static final /* synthetic */ Map access$parseGrpcWebTrailer(GRPCWebInterceptor $this, Buffer buffer) {
        return $this.parseGrpcWebTrailer(buffer);
    }

    public static final /* synthetic */ void access$setResponseCompressionPool$p(GRPCWebInterceptor $this, CompressionPool compressionPool) {
        $this.responseCompressionPool = compressionPool;
    }

    public static final /* synthetic */ CompressionPool access$getResponseCompressionPool$p(GRPCWebInterceptor $this) {
        return $this.responseCompressionPool;
    }
}

