/*
 * Decompiled with CFR 0.152.
 */
package build.buf.connect.okhttp;

import build.buf.connect.Code;
import build.buf.connect.ConnectError;
import build.buf.connect.StreamResult;
import build.buf.connect.http.HTTPClientInterface;
import build.buf.connect.http.HTTPRequest;
import build.buf.connect.http.HTTPResponse;
import build.buf.connect.http.Stream;
import build.buf.connect.http.TracingInfo;
import build.buf.connect.okhttp.ConnectOkHttpClientKt;
import build.buf.connect.okhttp.OkHttpStreamKt;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JB\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2(\u0010\u000b\u001a$\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00110\fH\u0016\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012J.\u0010\u0013\u001a\f\u0012\u0004\u0012\u00020\u00100\u0014j\u0002`\u00152\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00100\u0016H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0018"}, d2={"Lbuild/buf/connect/okhttp/ConnectOkHttpClient;", "Lbuild/buf/connect/http/HTTPClientInterface;", "client", "Lokhttp3/OkHttpClient;", "(Lokhttp3/OkHttpClient;)V", "getClient", "()Lokhttp3/OkHttpClient;", "stream", "Lbuild/buf/connect/http/Stream;", "request", "Lbuild/buf/connect/http/HTTPRequest;", "onResult", "Lkotlin/Function2;", "Lbuild/buf/connect/StreamResult;", "Lokio/Buffer;", "Lkotlin/coroutines/Continuation;", "", "", "(Lbuild/buf/connect/http/HTTPRequest;Lkotlin/jvm/functions/Function2;)Lbuild/buf/connect/http/Stream;", "unary", "Lkotlin/Function0;", "Lbuild/buf/connect/http/Cancelable;", "Lkotlin/Function1;", "Lbuild/buf/connect/http/HTTPResponse;", "okhttp"})
public final class ConnectOkHttpClient
implements HTTPClientInterface {
    @NotNull
    private final OkHttpClient client;

    @JvmOverloads
    public ConnectOkHttpClient(@NotNull OkHttpClient client) {
        Intrinsics.checkNotNullParameter(client, "client");
        this.client = client;
    }

    public /* synthetic */ ConnectOkHttpClient(OkHttpClient okHttpClient, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            okHttpClient = new OkHttpClient();
        }
        this(okHttpClient);
    }

    @NotNull
    public final OkHttpClient getClient() {
        return this.client;
    }

    @Override
    @NotNull
    public Function0<Unit> unary(@NotNull HTTPRequest request, @NotNull Function1<? super HTTPResponse, Unit> onResult) {
        Intrinsics.checkNotNullParameter(request, "request");
        Intrinsics.checkNotNullParameter(onResult, "onResult");
        Request.Builder builder = new Request.Builder();
        for (Map.Entry<String, List<String>> entry : request.getHeaders().entrySet()) {
            for (String values2 : entry.getValue()) {
                builder.addHeader(entry.getKey(), values2);
            }
        }
        byte[] byArray = request.getMessage();
        if (byArray == null) {
            byArray = new byte[]{};
        }
        byte[] content = byArray;
        RequestBody requestBody = RequestBody.Companion.create$default(RequestBody.Companion, content, MediaType.Companion.get(request.getContentType()), 0, 0, 6, null);
        Request callRequest = builder.url(request.getUrl()).post(requestBody).build();
        Call newCall = this.client.newCall(callRequest);
        Function0 cancelable2 = new Function0<Unit>(newCall){
            final /* synthetic */ Call $newCall;
            {
                this.$newCall = $newCall;
                super(0);
            }

            public final void invoke() {
                this.$newCall.cancel();
            }
        };
        try {
            newCall.enqueue(new Callback(onResult){
                final /* synthetic */ Function1<HTTPResponse, Unit> $onResult;
                {
                    this.$onResult = $onResult;
                }

                public void onFailure(@NotNull Call call, @NotNull IOException e) {
                    String string;
                    Intrinsics.checkNotNullParameter(call, "call");
                    Intrinsics.checkNotNullParameter(e, "e");
                    Object object = e.getMessage();
                    if (object == null) {
                        string = null;
                    } else {
                        String string2 = ((String)object).toLowerCase(Locale.ROOT);
                        string = string2;
                        Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).toLowerCase(Locale.ROOT)");
                    }
                    Code code = Intrinsics.areEqual(string, "canceled") ? Code.CANCELED : Code.UNKNOWN;
                    object = MapsKt.emptyMap();
                    Buffer buffer = new Buffer();
                    Map<K, V> map2 = MapsKt.emptyMap();
                    ConnectError connectError = new ConnectError(code, null, e.getMessage(), e, null, null, 50, null);
                    this.$onResult.invoke(new HTTPResponse(code, (Map<String, ? extends List<String>>)object, buffer, map2, null, connectError));
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onResponse(@NotNull Call call, @NotNull Response response) {
                    Buffer buffer;
                    Intrinsics.checkNotNullParameter(call, "call");
                    Intrinsics.checkNotNullParameter(response, "response");
                    ResponseBody responseBody = response.body();
                    if (responseBody == null) {
                        buffer = null;
                    } else {
                        BufferedSource bufferedSource = responseBody.source();
                        if (bufferedSource == null) {
                            buffer = null;
                        } else {
                            Closeable closeable = bufferedSource;
                            Throwable throwable = null;
                            try {
                                BufferedSource bufferedSource2 = (BufferedSource)closeable;
                                boolean bl = false;
                                Buffer buffer2 = new Buffer();
                                buffer2.writeAll(bufferedSource2);
                                Buffer buffer3 = buffer2;
                                buffer = buffer3;
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                CloseableKt.closeFinally(closeable, throwable);
                            }
                        }
                    }
                    Buffer responseBuffer = buffer;
                    Code code = Code.Companion.fromHTTPStatus(response.code());
                    Map<String, List<String>> map2 = ConnectOkHttpClientKt.toLowerCaseKeysMultiMap(response.headers());
                    Buffer buffer4 = responseBuffer;
                    if (buffer4 == null) {
                        buffer4 = new Buffer();
                    }
                    this.$onResult.invoke(new HTTPResponse(code, map2, buffer4, ConnectOkHttpClientKt.toLowerCaseKeysMultiMap(response.trailers()), new TracingInfo(response.code()), null, 32, null));
                }
            });
        }
        catch (Throwable e) {
            Code code = Code.UNKNOWN;
            Map map2 = MapsKt.emptyMap();
            Buffer buffer = new Buffer();
            Map map3 = MapsKt.emptyMap();
            ConnectError connectError = new ConnectError(Code.UNKNOWN, null, e.getMessage(), e, null, null, 50, null);
            onResult.invoke(new HTTPResponse(code, map2, buffer, map3, null, connectError));
        }
        return cancelable2;
    }

    @Override
    @NotNull
    public Stream stream(@NotNull HTTPRequest request, @NotNull Function2<? super StreamResult<Buffer>, ? super Continuation<? super Unit>, ? extends Object> onResult) {
        Intrinsics.checkNotNullParameter(request, "request");
        Intrinsics.checkNotNullParameter(onResult, "onResult");
        return OkHttpStreamKt.initializeStream(this.client, request, onResult);
    }

    @JvmOverloads
    public ConnectOkHttpClient() {
        this(null, 1, null);
    }
}

