/*
 * Decompiled with CFR 0.152.
 */
package build.buf.connect.protocols;

import build.buf.connect.Code;
import build.buf.connect.ConnectErrorDetail;
import build.buf.connect.ErrorDetailParser;
import build.buf.connect.protocols.GRPCCompletion;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlin.text.UStringsKt;
import okio.Buffer;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J,\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u001c\u0010\b\u001a\u0018\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00060\tj\u0002`\u000bH\u0002J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nH\u0002J\u0018\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J-\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u001c\u0010\b\u001a\u0018\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00060\tj\u0002`\u000bH\u0000\u00a2\u0006\u0002\b\u0014J&\u0010\u0015\u001a\u00020\u00162\u001c\u0010\b\u001a\u0018\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00060\tj\u0002`\u000bH\u0002J-\u0010\u0017\u001a\u0004\u0018\u00010\u00112\u001c\u0010\b\u001a\u0018\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00060\tj\u0002`\u000bH\u0002\u00a2\u0006\u0002\u0010\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lbuild/buf/connect/protocols/GRPCCompletionParser;", "", "errorDetailParser", "Lbuild/buf/connect/ErrorDetailParser;", "(Lbuild/buf/connect/ErrorDetailParser;)V", "connectErrorDetails", "", "Lbuild/buf/connect/ConnectErrorDetail;", "trailers", "", "", "Lbuild/buf/connect/Trailers;", "grpcPercentDecode", "encoded", "grpcPercentDecodeSlow", "str", "offset", "", "parse", "Lbuild/buf/connect/protocols/GRPCCompletion;", "parse$library", "parseMessage", "Lokio/ByteString;", "parseStatus", "(Ljava/util/Map;)Ljava/lang/Integer;", "library"})
public final class GRPCCompletionParser {
    @NotNull
    private final ErrorDetailParser errorDetailParser;

    public GRPCCompletionParser(@NotNull ErrorDetailParser errorDetailParser) {
        Intrinsics.checkNotNullParameter(errorDetailParser, "errorDetailParser");
        this.errorDetailParser = errorDetailParser;
    }

    @Nullable
    public final GRPCCompletion parse$library(@NotNull Map<String, ? extends List<String>> trailers) {
        Intrinsics.checkNotNullParameter(trailers, "trailers");
        Integer n = this.parseStatus(trailers);
        if (n == null) {
            return null;
        }
        int status = n;
        Code code = Code.Companion.fromValue(status);
        ByteString message = this.parseMessage(trailers);
        List<ConnectErrorDetail> details = this.connectErrorDetails(trailers);
        return new GRPCCompletion(code, status, message, details);
    }

    private final List<ConnectErrorDetail> connectErrorDetails(Map<String, ? extends List<String>> trailers) {
        byte[] rawError;
        List<String> list = trailers.get("grpc-status-details-bin");
        byte[] byArray = list != null && (list = CollectionsKt.first(list)) != null && (list = ByteString.Companion.decodeBase64((String)((Object)list))) != null ? ((ByteString)((Object)list)).toByteArray() : (rawError = null);
        if (rawError != null) {
            try {
                return this.errorDetailParser.parseDetails(rawError);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return CollectionsKt.emptyList();
    }

    private final Integer parseStatus(Map<String, ? extends List<String>> trailers) {
        List<String> list = trailers.get("grpc-status");
        return list != null && (list = CollectionsKt.first(list)) != null ? StringsKt.toIntOrNull((String)((Object)list)) : null;
    }

    private final ByteString parseMessage(Map<String, ? extends List<String>> trailers) {
        List<String> list = trailers.get("grpc-message");
        if (list == null || (list = CollectionsKt.first(list)) == null) {
            return ByteString.EMPTY;
        }
        List<String> message = list;
        return ByteString.Companion.encodeUtf8(this.grpcPercentDecode((String)((Object)message)));
    }

    private final String grpcPercentDecode(String encoded) {
        int n = encoded.length();
        for (int i = 0; i < n; ++i) {
            int index = i;
            char character = encoded.charAt(i);
            if (character != '%' || index + 2 >= encoded.length()) continue;
            return this.grpcPercentDecodeSlow(encoded, index);
        }
        return encoded;
    }

    private final String grpcPercentDecodeSlow(String str, int offset) {
        ByteString encoded = ByteString.Companion.encodeUtf8(str);
        Buffer buffer = new Buffer();
        buffer.write(encoded.substring(0, offset));
        int i = offset;
        while (i < encoded.size()) {
            char character = (char)encoded.getByte(i);
            if (character != '%' || i + 2 > encoded.size()) {
                buffer.writeByte(character);
                ++i;
                continue;
            }
            UInt parsed = UStringsKt.toUIntOrNull(encoded.substring(i + 1, i + 3).utf8(), 16);
            if (parsed != null) {
                buffer.writeByte(parsed.unbox-impl());
            }
            i += 3;
        }
        return buffer.readUtf8();
    }
}

