/*
 * Decompiled with CFR 0.152.
 */
package box.tapsi.libs.scheduler.scheduler.schedulers;

import box.tapsi.libs.scheduler.quartz.QuartzHelper;
import box.tapsi.libs.scheduler.scheduler.JobGroup;
import box.tapsi.libs.scheduler.scheduler.SchedulerException;
import box.tapsi.libs.scheduler.scheduler.SchedulingInstruction;
import box.tapsi.libs.scheduler.scheduler.Trigger;
import box.tapsi.libs.scheduler.scheduler.TriggerGroup;
import box.tapsi.libs.scheduler.scheduler.factories.QuartzTriggerFactory;
import box.tapsi.libs.scheduler.scheduler.schedulers.DefaultScheduler;
import box.tapsi.libs.scheduler.scheduler.services.SchedulerService;
import box.tapsi.libs.scheduler.scheduler.store.JobStore;
import box.tapsi.libs.utilities.reactor.ReactorContextExtensionsKt;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.quartz.JobExecutionContext;
import reactor.core.publisher.Mono;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0004J\"\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u000bH\u0016J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000bH\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lbox/tapsi/libs/scheduler/scheduler/schedulers/RegularScheduler;", "Lbox/tapsi/libs/scheduler/scheduler/schedulers/DefaultScheduler;", "schedulerService", "Lbox/tapsi/libs/scheduler/scheduler/services/SchedulerService;", "(Lbox/tapsi/libs/scheduler/scheduler/services/SchedulerService;)V", "getSchedulerService", "()Lbox/tapsi/libs/scheduler/scheduler/services/SchedulerService;", "reschedule", "Lreactor/core/publisher/Mono;", "Ljava/lang/Void;", "nextFireTimestamp", "Ljava/time/Instant;", "newTriggerId", "", "quartzTriggerFactory", "Lbox/tapsi/libs/scheduler/scheduler/factories/QuartzTriggerFactory;", "schedule", "jobStore", "Lbox/tapsi/libs/scheduler/scheduler/store/JobStore;", "fireTimestamp", "scheduleRegularJob", "scheduler-starter"})
public abstract class RegularScheduler
extends DefaultScheduler {
    @NotNull
    private final SchedulerService schedulerService;

    public RegularScheduler(@NotNull SchedulerService schedulerService) {
        Intrinsics.checkNotNullParameter((Object)schedulerService, (String)"schedulerService");
        this.schedulerService = schedulerService;
    }

    @NotNull
    protected final SchedulerService getSchedulerService() {
        return this.schedulerService;
    }

    @Override
    @NotNull
    public Mono<Void> schedule(@Nullable JobStore jobStore, @Nullable Instant fireTimestamp) {
        if (jobStore == null || fireTimestamp == null) {
            Mono mono = Mono.error((Throwable)((Throwable)((Object)new SchedulerException.NoJobStoreFoundException(this.getJobGroup().getValue()))));
            Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"error(...)");
            return mono;
        }
        return this.scheduleRegularJob(jobStore, fireTimestamp);
    }

    @NotNull
    protected Mono<Void> scheduleRegularJob(@NotNull JobStore jobStore, @NotNull Instant fireTimestamp) {
        Intrinsics.checkNotNullParameter((Object)jobStore, (String)"jobStore");
        Intrinsics.checkNotNullParameter((Object)fireTimestamp, (String)"fireTimestamp");
        Mono mono = Mono.fromSupplier(() -> RegularScheduler.scheduleRegularJob$lambda$0(this, jobStore, fireTimestamp)).flatMap(arg_0 -> RegularScheduler.scheduleRegularJob$lambda$1((Function1)new Function1<SchedulingInstruction.Regular, Mono<? extends Void>>(this){
            final /* synthetic */ RegularScheduler this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final Mono<? extends Void> invoke(SchedulingInstruction.Regular instruction) {
                SchedulerService schedulerService = this.this$0.getSchedulerService();
                Intrinsics.checkNotNull((Object)instruction);
                return schedulerService.scheduleRegularJob(instruction);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"flatMap(...)");
        return mono;
    }

    @NotNull
    protected final Mono<Void> reschedule(@NotNull Instant nextFireTimestamp, @Nullable String newTriggerId, @NotNull QuartzTriggerFactory quartzTriggerFactory) {
        Intrinsics.checkNotNullParameter((Object)nextFireTimestamp, (String)"nextFireTimestamp");
        Intrinsics.checkNotNullParameter((Object)quartzTriggerFactory, (String)"quartzTriggerFactory");
        return ReactorContextExtensionsKt.monoDeferWithObject((KClass)Reflection.getOrCreateKotlinClass(JobExecutionContext.class), arg_0 -> RegularScheduler.reschedule$lambda$2((Function1)new Function1<JobExecutionContext, Mono<? extends Void>>(quartzTriggerFactory, newTriggerId, nextFireTimestamp, this){
            final /* synthetic */ QuartzTriggerFactory $quartzTriggerFactory;
            final /* synthetic */ String $newTriggerId;
            final /* synthetic */ Instant $nextFireTimestamp;
            final /* synthetic */ RegularScheduler this$0;
            {
                this.$quartzTriggerFactory = $quartzTriggerFactory;
                this.$newTriggerId = $newTriggerId;
                this.$nextFireTimestamp = $nextFireTimestamp;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Mono<? extends Void> invoke(@NotNull JobExecutionContext ctx) {
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                org.quartz.Trigger trigger = ctx.getTrigger();
                Intrinsics.checkNotNullExpressionValue((Object)trigger, (String)"getTrigger(...)");
                Trigger trigger2 = this.$quartzTriggerFactory.createTrigger(trigger);
                Intrinsics.checkNotNull((Object)trigger2, (String)"null cannot be cast to non-null type box.tapsi.libs.scheduler.scheduler.Trigger.SimpleTrigger");
                Trigger.SimpleTrigger trigger3 = (Trigger.SimpleTrigger)trigger2;
                String rescheduledTriggerId = QuartzHelper.TriggerHelper.INSTANCE.prepareRescheduledTriggerId(trigger3.getTriggerId(), this.$newTriggerId);
                Trigger.SimpleTrigger rescheduledTrigger = Trigger.SimpleTrigger.copy$default(trigger3, null, null, null, rescheduledTriggerId, this.$nextFireTimestamp, null, 0, 103, null);
                return this.this$0.getSchedulerService().reschedule(trigger3.getTriggerId(), rescheduledTrigger);
            }
        }, arg_0));
    }

    public static /* synthetic */ Mono reschedule$default(RegularScheduler regularScheduler, Instant instant, String string, QuartzTriggerFactory quartzTriggerFactory, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: reschedule");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        return regularScheduler.reschedule(instant, string, quartzTriggerFactory);
    }

    private static final SchedulingInstruction.Regular scheduleRegularJob$lambda$0(RegularScheduler this$0, JobStore $jobStore, Instant $fireTimestamp) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$jobStore, (String)"$jobStore");
        Intrinsics.checkNotNullParameter((Object)$fireTimestamp, (String)"$fireTimestamp");
        KClass kClass = Reflection.getOrCreateKotlinClass(this$0.getClass());
        String string = this$0.createJobId($jobStore);
        Integer n = this$0.getRetriedCount($jobStore);
        JobGroup jobGroup = this$0.getJobGroup();
        TriggerGroup triggerGroup = this$0.getTriggerGroup();
        return new SchedulingInstruction.Regular($fireTimestamp, (KClass<? extends RegularScheduler>)kClass, $jobStore, string, n, jobGroup, triggerGroup);
    }

    private static final Mono scheduleRegularJob$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Mono)$tmp0.invoke(p0);
    }

    private static final Mono reschedule$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Mono)$tmp0.invoke(p0);
    }
}

