/*
 * Decompiled with CFR 0.152.
 */
package box.tapsi.libs.scheduler.scheduler.mappers;

import box.tapsi.libs.scheduler.quartz.QuartzTriggerBuilder;
import box.tapsi.libs.scheduler.scheduler.JobGroup;
import box.tapsi.libs.scheduler.scheduler.Trigger;
import box.tapsi.libs.scheduler.scheduler.TriggerGroup;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.quartz.CronTrigger;
import org.quartz.SimpleTrigger;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\t\nB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0004\u00a8\u0006\u000b"}, d2={"Lbox/tapsi/libs/scheduler/scheduler/mappers/TriggerMapper;", "", "()V", "fromModel", "Lbox/tapsi/libs/scheduler/scheduler/Trigger;", "quartzTrigger", "Lorg/quartz/Trigger;", "toModel", "trigger", "CronTriggerMapper", "SimpleTriggerMapper", "scheduler-starter"})
public final class TriggerMapper {
    @NotNull
    public static final TriggerMapper INSTANCE = new TriggerMapper();

    private TriggerMapper() {
    }

    @NotNull
    public final org.quartz.Trigger toModel(@NotNull Trigger trigger) {
        org.quartz.Trigger trigger2;
        Intrinsics.checkNotNullParameter((Object)trigger, (String)"trigger");
        Trigger trigger3 = trigger;
        if (trigger3 instanceof Trigger.SimpleTrigger) {
            trigger2 = SimpleTriggerMapper.INSTANCE.toModel((Trigger.SimpleTrigger)trigger);
        } else if (trigger3 instanceof Trigger.CronTrigger) {
            trigger2 = CronTriggerMapper.INSTANCE.toModel((Trigger.CronTrigger)trigger);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return trigger2;
    }

    @NotNull
    public final Trigger fromModel(@NotNull org.quartz.Trigger quartzTrigger) {
        Trigger trigger;
        Intrinsics.checkNotNullParameter((Object)quartzTrigger, (String)"quartzTrigger");
        org.quartz.Trigger trigger2 = quartzTrigger;
        if (trigger2 instanceof SimpleTrigger) {
            trigger = SimpleTriggerMapper.INSTANCE.fromModel((SimpleTrigger)quartzTrigger);
        } else if (trigger2 instanceof CronTrigger) {
            trigger = CronTriggerMapper.INSTANCE.fromModel((CronTrigger)quartzTrigger);
        } else {
            throw new IllegalStateException(("Unknown trigger type: " + quartzTrigger.getClass()).toString());
        }
        return trigger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004\u00a8\u0006\n"}, d2={"Lbox/tapsi/libs/scheduler/scheduler/mappers/TriggerMapper$CronTriggerMapper;", "", "()V", "fromModel", "Lbox/tapsi/libs/scheduler/scheduler/Trigger$CronTrigger;", "quartzTrigger", "Lorg/quartz/CronTrigger;", "toModel", "Lorg/quartz/Trigger;", "trigger", "scheduler-starter"})
    private static final class CronTriggerMapper {
        @NotNull
        public static final CronTriggerMapper INSTANCE = new CronTriggerMapper();

        private CronTriggerMapper() {
        }

        @NotNull
        public final org.quartz.Trigger toModel(@NotNull Trigger.CronTrigger trigger) {
            Intrinsics.checkNotNullParameter((Object)trigger, (String)"trigger");
            return new QuartzTriggerBuilder.Cron(trigger.getTriggerId(), trigger.getTriggerGroup().getValue(), trigger.getStartTimestamp(), trigger.getCronExpression()).build();
        }

        @NotNull
        public final Trigger.CronTrigger fromModel(@NotNull CronTrigger quartzTrigger) {
            Trigger.CronTrigger cronTrigger;
            Intrinsics.checkNotNullParameter((Object)quartzTrigger, (String)"quartzTrigger");
            String string = quartzTrigger.getJobKey().getGroup();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getGroup(...)");
            JobGroup jobGroup = JobGroup.Companion.fromString(string);
            String string2 = quartzTrigger.getJobKey().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            String string3 = quartzTrigger.getKey().getGroup();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getGroup(...)");
            TriggerGroup triggerGroup = TriggerGroup.Companion.fromString(string3);
            String string4 = quartzTrigger.getKey().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getName(...)");
            Instant instant = quartzTrigger.getStartTime().toInstant();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"toInstant(...)");
            String string5 = quartzTrigger.getCronExpression();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getCronExpression(...)");
            Trigger.CronTrigger $this$fromModel_u24lambda_u240 = cronTrigger = new Trigger.CronTrigger(jobGroup, string2, triggerGroup, string4, instant, string5);
            boolean bl = false;
            $this$fromModel_u24lambda_u240.setNextFireTimestamp(quartzTrigger.getNextFireTime().toInstant());
            $this$fromModel_u24lambda_u240.setMisFireInstruction(quartzTrigger.getMisfireInstruction());
            return cronTrigger;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004\u00a8\u0006\n"}, d2={"Lbox/tapsi/libs/scheduler/scheduler/mappers/TriggerMapper$SimpleTriggerMapper;", "", "()V", "fromModel", "Lbox/tapsi/libs/scheduler/scheduler/Trigger$SimpleTrigger;", "quartzTrigger", "Lorg/quartz/SimpleTrigger;", "toModel", "Lorg/quartz/Trigger;", "trigger", "scheduler-starter"})
    private static final class SimpleTriggerMapper {
        @NotNull
        public static final SimpleTriggerMapper INSTANCE = new SimpleTriggerMapper();

        private SimpleTriggerMapper() {
        }

        @NotNull
        public final org.quartz.Trigger toModel(@NotNull Trigger.SimpleTrigger trigger) {
            Intrinsics.checkNotNullParameter((Object)trigger, (String)"trigger");
            return new QuartzTriggerBuilder.Simple(trigger.getTriggerId(), trigger.getTriggerGroup().getValue(), trigger.getStartTimestamp(), trigger.getRepeatIntervalDuration().toMillis(), trigger.getRepeatCount()).build();
        }

        @NotNull
        public final Trigger.SimpleTrigger fromModel(@NotNull SimpleTrigger quartzTrigger) {
            Trigger.SimpleTrigger simpleTrigger;
            Intrinsics.checkNotNullParameter((Object)quartzTrigger, (String)"quartzTrigger");
            String string = quartzTrigger.getJobKey().getGroup();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getGroup(...)");
            JobGroup jobGroup = JobGroup.Companion.fromString(string);
            String string2 = quartzTrigger.getJobKey().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            String string3 = quartzTrigger.getKey().getGroup();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getGroup(...)");
            TriggerGroup triggerGroup = TriggerGroup.Companion.fromString(string3);
            String string4 = quartzTrigger.getKey().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getName(...)");
            Instant instant = quartzTrigger.getStartTime().toInstant();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"toInstant(...)");
            Trigger.SimpleTrigger $this$fromModel_u24lambda_u240 = simpleTrigger = new Trigger.SimpleTrigger(jobGroup, string2, triggerGroup, string4, instant, null, 0, 96, null);
            boolean bl = false;
            Date date = quartzTrigger.getNextFireTime();
            $this$fromModel_u24lambda_u240.setNextFireTimestamp(date != null ? date.toInstant() : null);
            $this$fromModel_u24lambda_u240.setMisFireInstruction(quartzTrigger.getMisfireInstruction());
            $this$fromModel_u24lambda_u240.setRepeatCount(quartzTrigger.getRepeatCount());
            Duration duration = Duration.ofMillis(quartzTrigger.getRepeatInterval());
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(...)");
            $this$fromModel_u24lambda_u240.setRepeatIntervalDuration(duration);
            return simpleTrigger;
        }
    }
}

