/*
 * Decompiled with CFR 0.152.
 */
package box.tapsi.libs.scheduler.scheduler.jobs;

import box.tapsi.libs.scheduler.quartz.metric.registry.QuartzRegistry;
import box.tapsi.libs.scheduler.scheduler.JobStoreExtensionsKt;
import box.tapsi.libs.scheduler.scheduler.SchedulerException;
import box.tapsi.libs.scheduler.scheduler.jobs.DefaultSchedulerJob;
import box.tapsi.libs.scheduler.scheduler.schedulers.DefaultScheduler;
import box.tapsi.libs.scheduler.scheduler.store.JobStore;
import box.tapsi.libs.utilities.logging.ReactorExtensionsKt;
import box.tapsi.libs.utilities.reactor.ReactorContextExtensionsKt;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.scheduling.quartz.QuartzJobBean;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SynchronousSink;
import reactor.kotlin.core.publisher.MonoExtensionsKt;

@Component
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0012J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0012J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J+\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\"\n\b\u0000\u0010\u0016\u0018\u0001*\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0092\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lbox/tapsi/libs/scheduler/scheduler/jobs/DefaultSchedulerJob;", "Lorg/springframework/scheduling/quartz/QuartzJobBean;", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "quartzRegistry", "Lbox/tapsi/libs/scheduler/quartz/metric/registry/QuartzRegistry;", "(Lorg/springframework/context/ApplicationContext;Lbox/tapsi/libs/scheduler/quartz/metric/registry/QuartzRegistry;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "couldIgnoreError", "", "err", "", "doExecute", "Lreactor/core/publisher/Mono;", "Ljava/lang/Void;", "context", "Lorg/quartz/JobExecutionContext;", "executeInternal", "", "executeScheduler", "TJob", "Lbox/tapsi/libs/scheduler/scheduler/schedulers/DefaultScheduler;", "jobStore", "Lbox/tapsi/libs/scheduler/scheduler/store/JobStore;", "scheduler-starter"})
public class DefaultSchedulerJob
extends QuartzJobBean {
    @NotNull
    private final ApplicationContext applicationContext;
    @NotNull
    private final QuartzRegistry quartzRegistry;
    private final Logger logger;

    public DefaultSchedulerJob(@NotNull ApplicationContext applicationContext, @NotNull QuartzRegistry quartzRegistry) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter((Object)quartzRegistry, (String)"quartzRegistry");
        this.applicationContext = applicationContext;
        this.quartzRegistry = quartzRegistry;
        this.logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    }

    protected void executeInternal(@NotNull JobExecutionContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.logger.info("Executing job " + context.getJobDetail().getKey().getName());
        Mono mono = this.doExecute(context).doOnSuccess(arg_0 -> DefaultSchedulerJob.executeInternal$lambda$0((Function1)new Function1<Void, Unit>(this, context){
            final /* synthetic */ DefaultSchedulerJob this$0;
            final /* synthetic */ JobExecutionContext $context;
            {
                this.this$0 = $receiver;
                this.$context = $context;
                super(1);
            }

            public final void invoke(Void it) {
                JobDetail jobDetail = this.$context.getJobDetail();
                DefaultSchedulerJob.access$getLogger$p(this.this$0).info("scheduler for " + (JobKey)(jobDetail != null ? jobDetail.getKey() : null) + " executed successfully");
            }
        }, arg_0)).onErrorResume(arg_0 -> DefaultSchedulerJob.executeInternal$lambda$1((Function1)new Function1<Throwable, Boolean>((Object)this){

            @NotNull
            public final Boolean invoke(@NotNull Throwable p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return DefaultSchedulerJob.access$couldIgnoreError((DefaultSchedulerJob)((Object)this.receiver), p0);
            }
        }, arg_0), arg_0 -> DefaultSchedulerJob.executeInternal$lambda$2((Function1)new Function1<Throwable, Mono<? extends Void>>(this, context){
            final /* synthetic */ DefaultSchedulerJob this$0;
            final /* synthetic */ JobExecutionContext $context;
            {
                this.this$0 = $receiver;
                this.$context = $context;
                super(1);
            }

            public final Mono<? extends Void> invoke(Throwable it) {
                JobDetail jobDetail = this.$context.getJobDetail();
                DefaultSchedulerJob.access$getLogger$p(this.this$0).error("Error executing scheduler for " + (JobKey)(jobDetail != null ? jobDetail.getKey() : null), it);
                return Mono.empty();
            }
        }, arg_0)).doOnError(arg_0 -> DefaultSchedulerJob.executeInternal$lambda$3((Function1)new Function1<Throwable, Unit>(this, context){
            final /* synthetic */ DefaultSchedulerJob this$0;
            final /* synthetic */ JobExecutionContext $context;
            {
                this.this$0 = $receiver;
                this.$context = $context;
                super(1);
            }

            public final void invoke(Throwable it) {
                JobDetail jobDetail = this.$context.getJobDetail();
                DefaultSchedulerJob.access$getLogger$p(this.this$0).error("Internal Error executing scheduler for " + (JobKey)(jobDetail != null ? jobDetail.getKey() : null), it);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"doOnError(...)");
        ReactorExtensionsKt.addTraceIdToReactorContext((Mono)mono).transform(arg_0 -> DefaultSchedulerJob.executeInternal$lambda$4((Function1)new Function1<Mono<Void>, Publisher<Void>>(this, context){
            final /* synthetic */ DefaultSchedulerJob this$0;
            final /* synthetic */ JobExecutionContext $context;
            {
                this.this$0 = $receiver;
                this.$context = $context;
                super(1);
            }

            public final Publisher<Void> invoke(Mono<Void> it) {
                QuartzRegistry quartzRegistry = DefaultSchedulerJob.access$getQuartzRegistry$p(this.this$0);
                Intrinsics.checkNotNull(it);
                JobDetail jobDetail = this.$context.getJobDetail();
                Intrinsics.checkNotNullExpressionValue((Object)jobDetail, (String)"getJobDetail(...)");
                return (Publisher)quartzRegistry.exposeExecutionMetrics(it, jobDetail);
            }
        }, arg_0)).block();
        this.logger.info("Job " + context.getJobDetail().getKey().getName() + " executed");
    }

    private Mono<Void> doExecute(JobExecutionContext context) {
        Mono mono = Mono.defer(() -> DefaultSchedulerJob.doExecute$lambda$5(this, context)).handle((arg_0, arg_1) -> DefaultSchedulerJob.doExecute$lambda$6(doExecute.2.INSTANCE, arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"handle(...)");
        Mono mono2 = MonoExtensionsKt.switchIfEmpty((Mono)mono, (Function0)((Function0)new Function0<Mono<JobStore>>(context){
            final /* synthetic */ JobExecutionContext $context;
            {
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final Mono<JobStore> invoke() {
                JobDetail jobDetail = this.$context.getJobDetail();
                Object object = jobDetail != null ? jobDetail.getKey() : null;
                Intrinsics.checkNotNull((Object)object);
                String string = object.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                Mono mono = Mono.error((Throwable)((Throwable)((Object)new SchedulerException.NoJobStoreFoundException(string))));
                Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"error(...)");
                return mono;
            }
        })).flatMap(arg_0 -> DefaultSchedulerJob.doExecute$lambda$7((Function1)new Function1<JobStore, Mono<? extends Void>>(this, context){
            final /* synthetic */ DefaultSchedulerJob this$0;
            final /* synthetic */ JobExecutionContext $context;
            {
                this.this$0 = $receiver;
                this.$context = $context;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final Mono<? extends Void> invoke(JobStore jobStore) {
                void context$iv;
                void this_$iv;
                DefaultSchedulerJob defaultSchedulerJob = this.this$0;
                JobExecutionContext jobExecutionContext = this.$context;
                Intrinsics.checkNotNull((Object)jobStore);
                JobStore jobStore$iv = jobStore;
                boolean $i$f$executeScheduler = false;
                Function1 function1 = (Function1)new Function1<DefaultScheduler, Unit>((DefaultSchedulerJob)this_$iv, (JobExecutionContext)context$iv){
                    final /* synthetic */ DefaultSchedulerJob this$0;
                    final /* synthetic */ JobExecutionContext $context;
                    {
                        this.this$0 = $receiver;
                        this.$context = $context;
                        super(1);
                    }

                    public final void invoke(DefaultScheduler it) {
                        JobDetail jobDetail = this.$context.getJobDetail();
                        DefaultSchedulerJob.access$getLogger$p(this.this$0).info("Scheduler class found for " + (JobKey)(jobDetail != null ? jobDetail.getKey() : null) + " is " + Reflection.getOrCreateKotlinClass(it.getClass()).getSimpleName());
                    }
                };
                Consumer consumer = new Consumer(function1){
                    private final /* synthetic */ Function1 function;
                    {
                        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                        this.function = function;
                    }

                    public final /* synthetic */ void accept(Object p0) {
                        this.function.invoke(p0);
                    }
                };
                function1 = (Function1)new Function1<DefaultScheduler, Mono<? extends Void>>(jobStore$iv){
                    final /* synthetic */ JobStore $jobStore;
                    {
                        this.$jobStore = $jobStore;
                        super(1);
                    }

                    public final Mono<? extends Void> invoke(DefaultScheduler cronScheduler) {
                        return cronScheduler.execute(this.$jobStore);
                    }
                };
                Mono mono = Mono.defer((Supplier)new Supplier(jobStore$iv, (JobExecutionContext)context$iv, (DefaultSchedulerJob)this_$iv){
                    final /* synthetic */ JobStore $jobStore;
                    final /* synthetic */ JobExecutionContext $context;
                    final /* synthetic */ DefaultSchedulerJob this$0;
                    {
                        this.$jobStore = $jobStore;
                        this.$context = $context;
                        this.this$0 = $receiver;
                    }

                    public final Mono<? extends DefaultScheduler> get() {
                        String string = this.$jobStore.getString("scheduler");
                        if (string == null) {
                            JobDetail jobDetail = this.$context.getJobDetail();
                            throw new IllegalArgumentException("no scheduler class found for " + (JobKey)(jobDetail != null ? jobDetail.getKey() : null));
                        }
                        String schedulerBeanName = string;
                        Object object = DefaultSchedulerJob.access$getApplicationContext$p(this.this$0).getBean(schedulerBeanName, DefaultScheduler.class);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getBean(...)");
                        DefaultScheduler scheduler = (DefaultScheduler)object;
                        return Mono.just((Object)scheduler);
                    }
                }).doOnNext(consumer).flatMap(new Function(function1){
                    private final /* synthetic */ Function1 function;
                    {
                        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                        this.function = function;
                    }

                    public final /* synthetic */ Object apply(Object p0) {
                        return this.function.invoke(p0);
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"flatMap(...)");
                return ReactorContextExtensionsKt.withContextualObject((Mono)mono, (Object)context$iv);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono2, (String)"flatMap(...)");
        return mono2;
    }

    private /* synthetic */ <TJob extends DefaultScheduler> Mono<Void> executeScheduler(JobExecutionContext context, JobStore jobStore) {
        boolean $i$f$executeScheduler = false;
        Intrinsics.needClassReification();
        Mono mono = Mono.defer((Supplier)new Supplier(jobStore, context, this){
            final /* synthetic */ JobStore $jobStore;
            final /* synthetic */ JobExecutionContext $context;
            final /* synthetic */ DefaultSchedulerJob this$0;
            {
                this.$jobStore = $jobStore;
                this.$context = $context;
                this.this$0 = $receiver;
            }

            public final Mono<? extends TJob> get() {
                String string = this.$jobStore.getString("scheduler");
                if (string == null) {
                    JobDetail jobDetail = this.$context.getJobDetail();
                    throw new IllegalArgumentException("no scheduler class found for " + (JobKey)(jobDetail != null ? jobDetail.getKey() : null));
                }
                String schedulerBeanName = string;
                ApplicationContext applicationContext = DefaultSchedulerJob.access$getApplicationContext$p(this.this$0);
                Intrinsics.reifiedOperationMarker((int)4, (String)"TJob");
                Object object = applicationContext.getBean(schedulerBeanName, DefaultScheduler.class);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getBean(...)");
                DefaultScheduler scheduler = (DefaultScheduler)object;
                return Mono.just((Object)scheduler);
            }
        });
        Intrinsics.needClassReification();
        Function1 function1 = new Function1<TJob, Unit>(this, context){
            final /* synthetic */ DefaultSchedulerJob this$0;
            final /* synthetic */ JobExecutionContext $context;
            {
                this.this$0 = $receiver;
                this.$context = $context;
                super(1);
            }

            public final void invoke(TJob it) {
                JobDetail jobDetail = this.$context.getJobDetail();
                DefaultSchedulerJob.access$getLogger$p(this.this$0).info("Scheduler class found for " + (JobKey)(jobDetail != null ? jobDetail.getKey() : null) + " is " + Reflection.getOrCreateKotlinClass(it.getClass()).getSimpleName());
            }
        };
        Mono mono2 = mono.doOnNext(new /* invalid duplicate definition of identical inner class */);
        Intrinsics.needClassReification();
        function1 = new Function1<TJob, Mono<? extends Void>>(jobStore){
            final /* synthetic */ JobStore $jobStore;
            {
                this.$jobStore = $jobStore;
                super(1);
            }

            public final Mono<? extends Void> invoke(TJob cronScheduler) {
                return cronScheduler.execute(this.$jobStore);
            }
        };
        Mono mono3 = mono2.flatMap(new /* invalid duplicate definition of identical inner class */);
        Intrinsics.checkNotNullExpressionValue((Object)mono3, (String)"flatMap(...)");
        return ReactorContextExtensionsKt.withContextualObject((Mono)mono3, (Object)context);
    }

    private boolean couldIgnoreError(Throwable err) {
        return !(err instanceof SchedulerException.NoSchedulerKeyFoundException) && !(err instanceof SchedulerException.NoJobStoreFoundException);
    }

    private static final void executeInternal$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final boolean executeInternal$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Mono executeInternal$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Mono)$tmp0.invoke(p0);
    }

    private static final void executeInternal$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Publisher executeInternal$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Publisher)$tmp0.invoke(p0);
    }

    private static final Mono doExecute$lambda$5(DefaultSchedulerJob this$0, JobExecutionContext $context) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        JobDetail jobDetail = $context.getJobDetail();
        this$0.logger.info("default scheduler job executed for " + (JobKey)(jobDetail != null ? jobDetail.getKey() : null) + " at " + $context.getFireTime());
        JobDetail jobDetail2 = $context.getJobDetail();
        JobStore jobStore = jobDetail2 != null && (jobDetail2 = jobDetail2.getJobDataMap()) != null ? JobStoreExtensionsKt.toJobStore((JobDataMap)jobDetail2) : null;
        return Mono.justOrEmpty((Object)jobStore);
    }

    private static final void doExecute$lambda$6(Function2 $tmp0, Object p0, SynchronousSink p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, (Object)p1);
    }

    private static final Mono doExecute$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Mono)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Logger access$getLogger$p(DefaultSchedulerJob $this) {
        return $this.logger;
    }

    public static final /* synthetic */ boolean access$couldIgnoreError(DefaultSchedulerJob $this, Throwable err) {
        return $this.couldIgnoreError(err);
    }

    public static final /* synthetic */ QuartzRegistry access$getQuartzRegistry$p(DefaultSchedulerJob $this) {
        return $this.quartzRegistry;
    }

    public static final /* synthetic */ ApplicationContext access$getApplicationContext$p(DefaultSchedulerJob $this) {
        return $this.applicationContext;
    }
}

