/*
 * Decompiled with CFR 0.152.
 */
package box.tapsi.libs.scheduler.scheduler.factories;

import box.tapsi.libs.scheduler.quartz.services.QuartzService;
import box.tapsi.libs.scheduler.scheduler.JobStoreExtensionsKt;
import box.tapsi.libs.scheduler.scheduler.SchedulingExtensionsKt;
import box.tapsi.libs.scheduler.scheduler.SchedulingInstruction;
import box.tapsi.libs.scheduler.scheduler.jobs.DefaultSchedulerJob;
import box.tapsi.libs.scheduler.scheduler.schedulers.Scheduler;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u0010H\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lbox/tapsi/libs/scheduler/scheduler/factories/QuartzJobDetailFactory;", "", "quartzService", "Lbox/tapsi/libs/scheduler/quartz/services/QuartzService;", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "(Lbox/tapsi/libs/scheduler/quartz/services/QuartzService;Lorg/springframework/context/ApplicationContext;)V", "createQuartzJobDetail", "Lorg/quartz/JobDetail;", "schedulingInstruction", "Lbox/tapsi/libs/scheduler/scheduler/SchedulingInstruction;", "putRegularSchedulerClassInJobDataMap", "", "jobDataMap", "Lorg/quartz/JobDataMap;", "scheduler", "Lkotlin/reflect/KClass;", "Lbox/tapsi/libs/scheduler/scheduler/schedulers/Scheduler;", "Companion", "scheduler-starter"})
public class QuartzJobDetailFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final QuartzService quartzService;
    @NotNull
    private final ApplicationContext applicationContext;
    @NotNull
    public static final String SCHEDULER_JOB_STORE_KEY_MAP = "scheduler";

    public QuartzJobDetailFactory(@NotNull QuartzService quartzService, @NotNull ApplicationContext applicationContext) {
        Intrinsics.checkNotNullParameter((Object)quartzService, (String)"quartzService");
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        this.quartzService = quartzService;
        this.applicationContext = applicationContext;
    }

    @NotNull
    public JobDetail createQuartzJobDetail(@NotNull SchedulingInstruction schedulingInstruction) {
        Intrinsics.checkNotNullParameter((Object)schedulingInstruction, (String)"schedulingInstruction");
        JobDataMap jobDataMap = JobStoreExtensionsKt.toJobDataMap(schedulingInstruction.getJobStore());
        this.putRegularSchedulerClassInJobDataMap(jobDataMap, schedulingInstruction.getScheduler());
        return this.quartzService.createJob(DefaultSchedulerJob.class, false, SchedulingExtensionsKt.getCompositeJobId(schedulingInstruction), schedulingInstruction.getJobGroup().getValue(), jobDataMap);
    }

    private void putRegularSchedulerClassInJobDataMap(JobDataMap jobDataMap, KClass<? extends Scheduler> scheduler) {
        ((Map)jobDataMap).put(SCHEDULER_JOB_STORE_KEY_MAP, CollectionsKt.first((Iterable)this.applicationContext.getBeansOfType(JvmClassMappingKt.getJavaClass(scheduler)).keySet()));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lbox/tapsi/libs/scheduler/scheduler/factories/QuartzJobDetailFactory$Companion;", "", "()V", "SCHEDULER_JOB_STORE_KEY_MAP", "", "scheduler-starter"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

