/*
 * Decompiled with CFR 0.152.
 */
package box.tapsi.libs.scheduler.quartz.services;

import box.tapsi.libs.scheduler.quartz.services.QuartzService;
import box.tapsi.libs.scheduler.quartz.services.QuartzServiceImpl;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.scheduling.quartz.JobDetailFactoryBean;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
@ConditionalOnMissingBean(value={QuartzServiceImpl.class})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J@\u0010\u0007\u001a\u00020\b\"\b\b\u0000\u0010\t*\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\t0\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u0010H\u0016J\u001e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001bH\u0016J\u001e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\"\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u001bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lbox/tapsi/libs/scheduler/quartz/services/QuartzServiceMockImpl;", "Lbox/tapsi/libs/scheduler/quartz/services/QuartzService;", "logger", "Lorg/slf4j/Logger;", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "(Lorg/slf4j/Logger;Lorg/springframework/context/ApplicationContext;)V", "createJob", "Lorg/quartz/JobDetail;", "TJob", "Lorg/quartz/Job;", "jobClass", "Ljava/lang/Class;", "isDurable", "", "jobName", "", "jobGroup", "jobDataMap", "Lorg/quartz/JobDataMap;", "deleteJob", "Lreactor/core/publisher/Mono;", "Ljava/lang/Void;", "jobKey", "Lorg/quartz/JobKey;", "getTriggers", "Lreactor/core/publisher/Flux;", "Lorg/quartz/Trigger;", "triggerGroup", "rescheduleJob", "triggerKey", "Lorg/quartz/TriggerKey;", "trigger", "scheduleJob", "jobDetail", "scheduler-starter"})
public class QuartzServiceMockImpl
implements QuartzService {
    @NotNull
    private final Logger logger;
    @NotNull
    private final ApplicationContext applicationContext;

    public QuartzServiceMockImpl(@NotNull Logger logger, @NotNull ApplicationContext applicationContext) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        this.logger = logger;
        this.applicationContext = applicationContext;
    }

    @Override
    @NotNull
    public <TJob extends Job> JobDetail createJob(@NotNull Class<TJob> jobClass, boolean isDurable, @NotNull String jobName, @NotNull String jobGroup, @NotNull JobDataMap jobDataMap) {
        JobDetailFactoryBean jobDetailFactoryBean;
        Intrinsics.checkNotNullParameter(jobClass, (String)"jobClass");
        Intrinsics.checkNotNullParameter((Object)jobName, (String)"jobName");
        Intrinsics.checkNotNullParameter((Object)jobGroup, (String)"jobGroup");
        Intrinsics.checkNotNullParameter((Object)jobDataMap, (String)"jobDataMap");
        JobDetailFactoryBean it = jobDetailFactoryBean = new JobDetailFactoryBean();
        boolean bl = false;
        this.logger.info("Creating a job with name: " + jobName + " and group: " + jobGroup + " in mock implementation");
        JobDetailFactoryBean $this$createJob_u24lambda_u241 = jobDetailFactoryBean;
        boolean bl2 = false;
        $this$createJob_u24lambda_u241.setJobClass(jobClass);
        $this$createJob_u24lambda_u241.setDurability(isDurable);
        $this$createJob_u24lambda_u241.setApplicationContext(this.applicationContext);
        $this$createJob_u24lambda_u241.setName(jobName);
        $this$createJob_u24lambda_u241.setGroup(jobGroup);
        ((Map)jobDataMap).put(jobName + jobGroup, jobClass.getName());
        $this$createJob_u24lambda_u241.setJobDataAsMap((Map)jobDataMap);
        $this$createJob_u24lambda_u241.afterPropertiesSet();
        it = jobDetailFactoryBean;
        boolean bl3 = false;
        this.logger.info("Job created successfully with name: " + jobName + " and group: " + jobGroup + " in mock implementation");
        it = jobDetailFactoryBean;
        boolean bl4 = false;
        JobDetail jobDetail = it.getObject();
        Intrinsics.checkNotNull((Object)jobDetail);
        Intrinsics.checkNotNullExpressionValue((Object)jobDetail, (String)"let(...)");
        return jobDetail;
    }

    @Override
    @NotNull
    public Mono<Void> scheduleJob(@NotNull JobDetail jobDetail, @NotNull Trigger trigger) {
        Intrinsics.checkNotNullParameter((Object)jobDetail, (String)"jobDetail");
        Intrinsics.checkNotNullParameter((Object)trigger, (String)"trigger");
        Mono mono = Mono.empty().doOnSuccess(arg_0 -> QuartzServiceMockImpl.scheduleJob$lambda$4((Function1)new Function1<Void, Unit>(this, jobDetail, trigger){
            final /* synthetic */ QuartzServiceMockImpl this$0;
            final /* synthetic */ JobDetail $jobDetail;
            final /* synthetic */ Trigger $trigger;
            {
                this.this$0 = $receiver;
                this.$jobDetail = $jobDetail;
                this.$trigger = $trigger;
                super(1);
            }

            public final void invoke(Void it) {
                QuartzServiceMockImpl.access$getLogger$p(this.this$0).info("Job scheduled successfully with job name: " + this.$jobDetail.getKey() + " and trigger: " + this.$trigger.getStartTime() + " in mock implementation");
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"doOnSuccess(...)");
        return mono;
    }

    @Override
    @NotNull
    public Mono<Void> deleteJob(@NotNull JobKey jobKey) {
        Intrinsics.checkNotNullParameter((Object)jobKey, (String)"jobKey");
        Mono mono = Mono.empty().doOnSuccess(arg_0 -> QuartzServiceMockImpl.deleteJob$lambda$5((Function1)new Function1<Void, Unit>(this, jobKey){
            final /* synthetic */ QuartzServiceMockImpl this$0;
            final /* synthetic */ JobKey $jobKey;
            {
                this.this$0 = $receiver;
                this.$jobKey = $jobKey;
                super(1);
            }

            public final void invoke(Void it) {
                QuartzServiceMockImpl.access$getLogger$p(this.this$0).info("Job deleted successfully with job name: " + this.$jobKey + " in mock implementation");
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"doOnSuccess(...)");
        return mono;
    }

    @Override
    @NotNull
    public Mono<Void> rescheduleJob(@NotNull TriggerKey triggerKey, @NotNull Trigger trigger) {
        Intrinsics.checkNotNullParameter((Object)triggerKey, (String)"triggerKey");
        Intrinsics.checkNotNullParameter((Object)trigger, (String)"trigger");
        Mono mono = Mono.empty().doOnSuccess(arg_0 -> QuartzServiceMockImpl.rescheduleJob$lambda$6((Function1)new Function1<Void, Unit>(this, trigger){
            final /* synthetic */ QuartzServiceMockImpl this$0;
            final /* synthetic */ Trigger $trigger;
            {
                this.this$0 = $receiver;
                this.$trigger = $trigger;
                super(1);
            }

            public final void invoke(Void it) {
                QuartzServiceMockImpl.access$getLogger$p(this.this$0).info("Job rescheduled successfully with trigger name: " + this.$trigger.getKey() + " in mock implementation");
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)mono, (String)"doOnSuccess(...)");
        return mono;
    }

    @Override
    @NotNull
    public Flux<Trigger> getTriggers(@NotNull String triggerGroup) {
        Intrinsics.checkNotNullParameter((Object)triggerGroup, (String)"triggerGroup");
        this.logger.info("Getting triggers for the group: " + triggerGroup + " in mock implementation");
        Flux flux = Flux.empty();
        Intrinsics.checkNotNullExpressionValue((Object)flux, (String)"empty(...)");
        return flux;
    }

    private static final void scheduleJob$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void deleteJob$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void rescheduleJob$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ Logger access$getLogger$p(QuartzServiceMockImpl $this) {
        return $this.logger;
    }
}

