/*
 * Decompiled with CFR 0.152.
 */
package be.yildizgames.engine.feature.construction;

import be.yildizgames.common.model.EntityId;
import be.yildizgames.common.model.PlayerId;
import be.yildizgames.engine.feature.construction.BuilderManager;
import be.yildizgames.engine.feature.construction.ConstructionListener;
import be.yildizgames.engine.feature.construction.ConstructionQueue;
import be.yildizgames.engine.feature.construction.ConstructionQueueListener;
import be.yildizgames.engine.feature.construction.QueueBuilder;
import be.yildizgames.engine.feature.construction.WaitingEntity;
import be.yildizgames.engine.feature.entity.EntityInConstruction;
import be.yildizgames.engine.feature.entity.construction.EntityConstructionStatus;
import be.yildizgames.engine.feature.entity.data.EntityType;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class ConstructionQueueManager<R extends EntityConstructionStatus, E extends EntityInConstruction>
implements ConstructionListener<E> {
    private final List<ConstructionQueueListener> listeners = new ArrayList<ConstructionQueueListener>();
    private final BuilderManager<QueueBuilder<R>> builderManager;

    public ConstructionQueueManager(BuilderManager<QueueBuilder<R>> builderManager) {
        assert (builderManager != null);
        this.builderManager = builderManager;
    }

    public void willNotify(ConstructionQueueListener listener) {
        assert (listener != null);
        this.listeners.add(listener);
    }

    public void cancel(PlayerId playerId, int index) {
        List<QueueBuilder<R>> builders = this.builderManager.getBuilderByPlayer(playerId);
        builders.forEach(b -> b.cancel(index));
    }

    public void update(ConstructionQueue<R> items) {
        Optional<QueueBuilder<R>> builder = this.builderManager.getBuilderById(items.getBuilderId());
        builder.ifPresent(b -> {
            b.setQueue(items.getList());
            this.listeners.forEach(l -> l.notify(b.getQueue()));
        });
    }

    public void addEntity(PlayerId playerId, EntityId builderId, R toBuild) {
        Optional<QueueBuilder<R>> builder = this.builderManager.getBuilderById(builderId);
        builder.ifPresent(b -> {
            b.addInQueue(toBuild);
            if (b.getQueue().hasOnlyOneElement()) {
                this.listeners.forEach(l -> l.add((EntityConstructionStatus)toBuild, playerId, builderId));
            }
            this.listeners.forEach(l -> l.notify(b.getQueue()));
        });
    }

    @Override
    public void entityComplete(EntityId entity, PlayerId owner, EntityType type, EntityId builder, int index) {
        if (builder.equals((Object)EntityId.WORLD)) {
            return;
        }
        this.builderManager.getBuilderById(builder).ifPresent(b -> {
            b.removeFromQueue(index);
            if (!b.getQueue().isEmpty()) {
                EntityConstructionStatus nextToBuild = (EntityConstructionStatus)b.getQueue().getList().get(0);
                this.listeners.forEach(l -> l.add(nextToBuild, b.getOwner(), builder));
            }
            this.listeners.forEach(l -> l.notify(b.getQueue()));
        });
    }

    @Override
    public void entityConstructionCanceled(WaitingEntity<E> w) {
        this.builderManager.getBuilderById(w.builderId).ifPresent(b -> {
            b.removeFromQueue(w.representation.index);
            if (!b.getQueue().isEmpty()) {
                EntityConstructionStatus nextToBuild = (EntityConstructionStatus)b.getQueue().getList().get(0);
                this.listeners.forEach(l -> l.add(nextToBuild, w.entity.getOwner(), w.builderId));
            }
            this.listeners.forEach(l -> l.notify(b.getQueue()));
        });
    }
}

