/*
 * Decompiled with CFR 0.152.
 */
package be.yildizgames.engine.feature.construction;

import be.yildizgames.common.model.EntityId;
import be.yildizgames.engine.feature.construction.ConstructionQueueFullException;
import be.yildizgames.engine.feature.entity.construction.EntityConstructionStatus;
import be.yildizgames.engine.feature.entity.data.EntityType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ConstructionQueue<R extends EntityConstructionStatus> {
    private final List<R> entities = new ArrayList<R>();
    private final EntityId builderId;
    private int maxSize = 0;

    public ConstructionQueue(EntityId builderId, int maxSize) {
        assert (builderId != null);
        this.builderId = builderId;
        this.maxSize = maxSize;
    }

    public void add(R e) {
        if (this.entities.size() == this.maxSize) {
            throw new ConstructionQueueFullException();
        }
        this.entities.add(e);
    }

    public boolean isEmpty() {
        return this.entities.isEmpty();
    }

    public void set(List<R> list) {
        this.entities.clear();
        if (list.size() > this.maxSize) {
            throw new ConstructionQueueFullException();
        }
        if (list.contains(null)) {
            throw new NullPointerException("The list contains null values.");
        }
        this.entities.addAll(list);
    }

    public List<R> getList() {
        return Collections.unmodifiableList(this.entities);
    }

    public boolean remove(int request) {
        for (EntityConstructionStatus e : this.entities) {
            if (e.index != request) continue;
            this.entities.remove(e);
            return true;
        }
        return false;
    }

    public int getNumberOfEntities(EntityType type) {
        int result = 0;
        for (EntityConstructionStatus c : this.entities) {
            if (!c.type.equals((Object)type)) continue;
            ++result;
        }
        return result;
    }

    public boolean hasOnlyOneElement() {
        return this.entities.size() == 1;
    }

    public EntityId getBuilderId() {
        return this.builderId;
    }
}

