/*
 * Decompiled with CFR 0.152.
 */
package be.yildizgames.engine.feature.construction;

import be.yildizgames.common.frame.EndFrameListener;
import be.yildizgames.common.frame.FrameListener;
import be.yildizgames.common.frame.FrameManager;
import be.yildizgames.common.logging.LogFactory;
import be.yildizgames.common.model.EntityId;
import be.yildizgames.common.model.PlayerId;
import be.yildizgames.engine.feature.construction.CompleteConstructionManager;
import be.yildizgames.engine.feature.construction.ConstructionListener;
import be.yildizgames.engine.feature.construction.EntityFactory;
import be.yildizgames.engine.feature.construction.WaitingEntity;
import be.yildizgames.engine.feature.entity.Entity;
import be.yildizgames.engine.feature.entity.EntityCreator;
import be.yildizgames.engine.feature.entity.EntityInConstruction;
import be.yildizgames.engine.feature.entity.EntityToCreate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public class ConstructionManager<T extends Entity, E extends EntityInConstruction, D>
extends EndFrameListener
implements CompleteConstructionManager<E> {
    private static final Logger LOGGER = LogFactory.getInstance().getLogger(ConstructionManager.class);
    private final List<WaitingEntity<E>> entityToBuildList = new ArrayList<WaitingEntity<E>>();
    private final EntityFactory<T, E> associatedFactory;
    private final Set<ConstructionListener> listenerList = new TreeSet<ConstructionListener>();
    private final EntityCreator creator;
    private List<EntityToCreate> entityToCreateList = new ArrayList<EntityToCreate>();

    public ConstructionManager(FrameManager frame, EntityFactory<T, E> factory, EntityCreator creator) {
        this.associatedFactory = factory;
        this.creator = creator;
        frame.addFrameListener((FrameListener)this);
    }

    @Override
    public void createEntity(E entity, EntityId builderId, int index) {
        Object buildEntity = this.associatedFactory.createEntity(entity);
        LOGGER.debug("Entity built " + entity.getId());
        this.listenerList.forEach(l -> l.entityComplete(buildEntity.getId(), buildEntity.getOwner(), buildEntity.getType(), builderId, index));
    }

    @Override
    public void createEntity(EntityToCreate entity) {
        this.entityToCreateList.add(entity);
    }

    @Override
    public void cancel(WaitingEntity w) {
        if (this.entityToBuildList.remove(w)) {
            this.listenerList.forEach(l -> l.entityConstructionCanceled(w));
        }
    }

    public boolean frameEnded(long time) {
        for (int i = 0; i < this.entityToBuildList.size(); ++i) {
            WaitingEntity<E> waitingEntity = this.entityToBuildList.get(i);
            waitingEntity.representation.reduceTimeLeft(time);
            if (!waitingEntity.representation.isTimeElapsed()) continue;
            Object buildEntity = this.associatedFactory.createEntity(waitingEntity.entity);
            LOGGER.debug("Entity built " + waitingEntity.entity.getId());
            this.listenerList.forEach(l -> l.entityComplete(buildEntity.getId(), buildEntity.getOwner(), buildEntity.getType(), waitingEntity.builderId, waitingEntity.representation.index));
            this.entityToBuildList.remove(i);
            --i;
        }
        while (!this.entityToCreateList.isEmpty()) {
            this.creator.create(this.entityToCreateList.remove(0));
        }
        return true;
    }

    @Override
    public void willNotify(ConstructionListener ... listeners) {
        if (listeners != null) {
            Collections.addAll(this.listenerList, listeners);
        }
    }

    public void removeListener(ConstructionListener listener) {
        this.listenerList.remove(listener);
    }

    @Override
    public List<WaitingEntity> getEntityToBuildList() {
        return Collections.unmodifiableList(this.entityToBuildList);
    }

    @Override
    public List<WaitingEntity> getEntityToBuildList(PlayerId player) {
        return this.entityToBuildList.stream().filter(w -> w.isOwned(player)).collect(Collectors.toList());
    }
}

