/*
 * Decompiled with CFR 0.152.
 */
package be.yildizgames.engine.feature.construction;

import be.yildizgames.common.model.EntityId;
import be.yildizgames.common.model.PlayerId;
import be.yildizgames.engine.feature.construction.Builder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class BuilderManager<B extends Builder> {
    private final Map<EntityId, B> builderList = new HashMap<EntityId, B>();
    private final Map<PlayerId, List<B>> buildersByPlayer = new HashMap<PlayerId, List<B>>();

    public Optional<B> getBuilderById(EntityId builderId) {
        return Optional.ofNullable((Builder)this.builderList.get(builderId));
    }

    public void addBuilder(B builder) {
        this.builderList.put(builder.getBuilderId(), builder);
        if (!this.buildersByPlayer.containsKey(builder.getOwner())) {
            this.buildersByPlayer.put(builder.getOwner(), new ArrayList());
        }
        this.buildersByPlayer.get(builder.getOwner()).add(builder);
    }

    public List<B> getBuilderByPlayer(PlayerId player) {
        assert (player != null);
        return Collections.unmodifiableList(this.buildersByPlayer.getOrDefault(player, Collections.emptyList()));
    }
}

