/*
 * Decompiled with CFR 0.152.
 */
package be.yildizgames.common.libloader;

import be.yildizgames.common.compression.CompressionFactory;
import be.yildizgames.common.compression.Unpacker;
import be.yildizgames.common.os.OperatingSystem;
import be.yildizgames.common.os.SystemUtil;
import be.yildizgames.common.os.factory.OperatingSystems;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.stream.Stream;

public final class NativeResourceLoader {
    private static final System.Logger LOGGER = System.getLogger(NativeResourceLoader.class.getName());
    public final String directory;
    public final Path libDirectory;
    public final String libraryExtension;
    private final Map<String, String> availableLib = new HashMap<String, String>();
    private final Unpacker jarHandler = CompressionFactory.zipUnpacker();

    private NativeResourceLoader(boolean decompress, OperatingSystem ... systemToSupport) {
        this(Paths.get(System.getProperty("user.home"), new String[0]).resolve("app-root").resolve("data").toString(), decompress, systemToSupport);
    }

    private NativeResourceLoader(String path, boolean decompress, OperatingSystem ... systemToSupport) {
        OperatingSystem nos = this.findSystem(systemToSupport);
        this.libraryExtension = nos.getExtension();
        this.directory = nos.getName();
        this.libDirectory = Paths.get(path, new String[0]);
        if (decompress) {
            LOGGER.log(System.Logger.Level.DEBUG, "Unpacking {} folder from jar to {} folder.", this.directory, this.libDirectory);
            Arrays.stream(System.getProperty("java.class.path", "").split(File.pathSeparator)).filter(s -> s.endsWith(".jar")).map(x$0 -> Paths.get(x$0, new String[0])).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).forEach(app -> this.jarHandler.unpackDirectoryToDirectory(app, this.directory, this.libDirectory));
        }
        try {
            this.registerLibInDir();
        }
        catch (IOException e) {
            LOGGER.log(System.Logger.Level.ERROR, "Cannot register libs", (Throwable)e);
        }
    }

    public static NativeResourceLoader inJar(OperatingSystem ... systemToSupport) {
        return new NativeResourceLoader(true, systemToSupport);
    }

    public static NativeResourceLoader inJar() {
        return new NativeResourceLoader(true, OperatingSystems.getAll());
    }

    public static NativeResourceLoader inJar(String path, OperatingSystem ... systemToSupport) {
        return new NativeResourceLoader(path, true, systemToSupport);
    }

    public static NativeResourceLoader inJar(String path) {
        return new NativeResourceLoader(path, true, OperatingSystems.getAll());
    }

    public static NativeResourceLoader inPath(String path, OperatingSystem ... systemToSupport) {
        return new NativeResourceLoader(path, false, systemToSupport);
    }

    public static NativeResourceLoader inTestPath(OperatingSystem ... systemToSupport) {
        return new NativeResourceLoader(new File("").getAbsolutePath() + "/target/classes", false, systemToSupport);
    }

    public static NativeResourceLoader external(OperatingSystem ... systemToSupport) {
        String path = new File("").getParentFile().getAbsolutePath();
        return new NativeResourceLoader(path, false, systemToSupport);
    }

    private OperatingSystem findSystem(OperatingSystem[] systemToSupport) {
        return Arrays.stream(systemToSupport).filter(OperatingSystem::isCurrent).findFirst().orElseThrow(IllegalStateException::new);
    }

    public String getLibPath(String lib) {
        Path f = Paths.get((String)(lib.endsWith(this.libraryExtension) ? lib : lib + this.libraryExtension), new String[0]);
        if (Files.exists(f, new LinkOption[0])) {
            return f.toAbsolutePath().toString();
        }
        String nativePath = this.availableLib.get(f.getFileName().toString());
        if (nativePath == null) {
            throw new IllegalStateException(lib + " has not been found in path.");
        }
        return nativePath;
    }

    public void loadLibrary(String ... libs) {
        for (String lib : libs) {
            String nativePath = this.getLibPath(lib);
            LOGGER.log(System.Logger.Level.DEBUG, "Loading native : {}", nativePath);
            System.load(nativePath);
            LOGGER.log(System.Logger.Level.DEBUG, "{} loaded.", nativePath);
        }
    }

    private void registerLibInDir(Path dir) throws IOException {
        if (Files.exists(dir, new LinkOption[0]) && Files.isDirectory(dir, new LinkOption[0])) {
            try (Stream<Path> walk = Files.walk(dir, new FileVisitOption[0]);){
                walk.filter(p -> Files.isRegularFile(p, new LinkOption[0]) && p.toString().endsWith(this.libraryExtension)).forEach(p -> this.availableLib.put(p.getFileName().toString(), p.toAbsolutePath().toString()));
            }
        }
    }

    private void registerLibInDir() throws IOException {
        this.registerLibInDir(this.libDirectory.resolve(this.directory).toAbsolutePath());
    }

    public void loadBaseLibrary(String ... libs) {
        if (SystemUtil.isWindows()) {
            this.loadLibrary("libgcc_s_seh-1.dll", "libstdc++-6.dll");
            if (libs != null && libs.length > 0) {
                this.loadLibrary(libs);
            }
        }
    }

    public List<String> getLoadedLibraries() {
        try {
            Field lib = ClassLoader.class.getDeclaredField("loadedLibraryNames");
            lib.setAccessible(true);
            return new ArrayList<String>((Collection)Vector.class.cast(lib.get(ClassLoader.getSystemClassLoader())));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

