/*
 * Decompiled with CFR 0.152.
 */
package be.yildizgames.common.geometry;

import be.yildizgames.common.geometry.Point2D;

public final class Rectangle {
    private int left;
    private int top;
    private int right;
    private int bottom;

    public Rectangle(int left, int top, int right, int bottom) {
        this.left = left;
        this.right = right;
        this.top = top;
        this.bottom = bottom;
    }

    public Rectangle() {
    }

    public boolean contain(float x, float y) {
        int y2;
        int y1;
        int x2;
        int x1;
        if (this.left <= this.right) {
            x1 = this.left;
            x2 = this.right;
        } else {
            x1 = this.right;
            x2 = this.left;
        }
        if (this.top <= this.bottom) {
            y1 = this.top;
            y2 = this.bottom;
        } else {
            y1 = this.bottom;
            y2 = this.top;
        }
        return x >= (float)x1 && x <= (float)x2 && y >= (float)y1 && y <= (float)y2;
    }

    public boolean contain(Point2D point) {
        return this.contain(point.x, point.y);
    }

    public int getHeight() {
        if (this.top > this.bottom) {
            return this.top - this.bottom;
        }
        return this.bottom - this.top;
    }

    public int getWidth() {
        if (this.left > this.right) {
            return this.left - this.right;
        }
        return this.right - this.left;
    }

    public void move(int x, int y) {
        this.setLeft(this.left + x);
        this.setRight(this.right + x);
        this.setTop(this.top + y);
        this.setBottom(this.bottom + y);
    }

    public void normalize() {
        int temp;
        if (this.left > this.right) {
            temp = this.left;
            this.left = this.right;
            this.right = temp;
        }
        if (this.top > this.bottom) {
            temp = this.top;
            this.top = this.bottom;
            this.bottom = temp;
        }
    }

    public void reset() {
        this.left = 0;
        this.right = 0;
        this.top = 0;
        this.bottom = 0;
    }

    public void setValues(int leftValue, int topValue, int rightValue, int bottomValue) {
        this.left = leftValue;
        this.right = rightValue;
        this.top = topValue;
        this.bottom = bottomValue;
    }

    public int getLeft() {
        return this.left;
    }

    public int getTop() {
        return this.top;
    }

    public int getRight() {
        return this.right;
    }

    public int getBottom() {
        return this.bottom;
    }

    public void setLeft(int left) {
        this.left = left;
    }

    public void setTop(int top) {
        this.top = top;
    }

    public void setRight(int right) {
        this.right = right;
    }

    public void setBottom(int bottom) {
        this.bottom = bottom;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Rectangle)) {
            return false;
        }
        Rectangle other = (Rectangle)o;
        return this.getLeft() == other.getLeft() && this.getTop() == other.getTop() && this.getRight() == other.getRight() && this.getBottom() == other.getBottom();
    }

    public int hashCode() {
        int prime = 59;
        int result = 1;
        result = result * 59 + this.getLeft();
        result = result * 59 + this.getTop();
        result = result * 59 + this.getRight();
        result = result * 59 + this.getBottom();
        return result;
    }

    public String toString() {
        return "be.yildiz.common.Rectangle(left=" + this.getLeft() + ", top=" + this.getTop() + ", right=" + this.getRight() + ", bottom=" + this.getBottom() + ")";
    }
}

