/*
 * Decompiled with CFR 0.152.
 */
package be.yildizgames.common.geometry;

import be.yildizgames.common.geometry.Degree;

public class Radian {
    public static final double PI2 = Math.PI * 2;
    public final float angle;

    private Radian(double radian) {
        this.angle = (float)radian;
    }

    public static Radian valueOf(float radian) {
        return new Radian(radian);
    }

    public static Radian valueOf(Degree degree) {
        return new Radian((double)degree.getUniformValue() * Math.PI / 180.0);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Radian)) {
            return false;
        }
        Radian other = (Radian)obj;
        return Float.valueOf(this.angle).equals(Float.valueOf(other.angle));
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        int temp = Float.floatToIntBits(this.angle);
        result = 31 * result + temp;
        return result;
    }

    public final String toString() {
        return "Radian value: " + this.angle;
    }
}

