/*
 * Decompiled with CFR 0.152.
 */
package be.yildizgames.common.geometry;

import be.yildizgames.common.geometry.Axis;

public final class Point3D {
    private static final float EPSILON = 1.0E-5f;
    public static final Point3D X_NEGATIVE = Point3D.valueOfX(-1.0f);
    public static final Point3D Y_NEGATIVE = Point3D.valueOfY(-1.0f);
    public static final Point3D Z_NEGATIVE = Point3D.valueOfZ(-1.0f);
    public static final Point3D X_POSITIVE = Point3D.valueOfX(1.0f);
    public static final Point3D Y_POSITIVE = Point3D.valueOfY(1.0f);
    public static final Point3D Z_POSITIVE = Point3D.valueOfZ(1.0f);
    public static final Point3D ZERO = Point3D.valueOf(0.0f);
    public static final Point3D BASE_DIRECTION = Z_NEGATIVE;
    public final float x;
    public final float y;
    public final float z;

    private Point3D(float xValue, float yValue, float zValue) {
        this.x = xValue;
        this.y = yValue;
        this.z = zValue;
    }

    public static Point3D valueOf(float x, float y, float z) {
        return new Point3D(x, y, z);
    }

    public static Point3D valueOf(float xyz) {
        return Point3D.valueOf(xyz, xyz, xyz);
    }

    public static Point3D valueOfX(float x) {
        return Point3D.valueOf(x, 0.0f, 0.0f);
    }

    public static Point3D valueOfY(float y) {
        return Point3D.valueOf(0.0f, y, 0.0f);
    }

    public static Point3D valueOfZ(float z) {
        return Point3D.valueOf(0.0f, 0.0f, z);
    }

    public static Point3D valueOfXY(float x, float y) {
        return Point3D.valueOf(x, y, 0.0f);
    }

    public static Point3D valueOfXY(float xy) {
        return Point3D.valueOfXY(xy, xy);
    }

    public static Point3D valueOfXZ(float x, float z) {
        return Point3D.valueOf(x, 0.0f, z);
    }

    public static Point3D valueOfXZ(float xz) {
        return Point3D.valueOfXZ(xz, xz);
    }

    public static Point3D valueOfYZ(float y, float z) {
        return Point3D.valueOf(0.0f, y, z);
    }

    public static Point3D valueOfYZ(float yz) {
        return Point3D.valueOfYZ(yz, yz);
    }

    public static Point3D addPoints(Point3D ... points) {
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        for (Point3D point : points) {
            assert (point != null);
            x += point.x;
            y += point.y;
            z += point.z;
        }
        return Point3D.valueOf(x, y, z);
    }

    public static Point3D normalize(Point3D p) {
        return Point3D.normalizeAndMultiply(p, 1.0f);
    }

    public static Point3D normalizeAndMultiply(Point3D p, float scalar) {
        assert (p != null);
        float length = (float)Math.sqrt(p.x * p.x + p.y * p.y + p.z * p.z);
        if (Math.abs(length) > 1.0E-6f) {
            return Point3D.valueOf(scalar * (p.x / length), scalar * (p.y / length), scalar * (p.z / length));
        }
        return p;
    }

    public static float squaredDistance(Point3D p1, Point3D p2) {
        assert (p1 != null);
        assert (p2 != null);
        float valueX = p1.x - p2.x;
        float valueY = p1.y - p2.y;
        float valueZ = p1.z - p2.z;
        return valueX * valueX + valueY * valueY + valueZ * valueZ;
    }

    public Point3D add(float x, float y, float z) {
        return Point3D.valueOf(this.x + x, this.y + y, this.z + z);
    }

    public Point3D add(Point3D point) {
        assert (point != null);
        return Point3D.valueOf(this.x + point.x, this.y + point.y, this.z + point.z);
    }

    public Point3D addX(float value) {
        return Point3D.valueOf(this.x + value, this.y, this.z);
    }

    public Point3D addY(float value) {
        return Point3D.valueOf(this.x, this.y + value, this.z);
    }

    public Point3D addZ(float value) {
        return Point3D.valueOf(this.x, this.y, this.z + value);
    }

    public float getAngle(Axis axis) {
        assert (axis != null);
        switch (axis) {
            case XY: {
                return (float)Math.atan2(this.y, this.x);
            }
            case XZ: {
                return (float)Math.atan2(this.z, this.x);
            }
            case ZY: {
                return (float)Math.atan2(this.y, this.z);
            }
        }
        throw new IllegalArgumentException(axis + " is unknown.");
    }

    public Point3D getInverse() {
        return Point3D.valueOf(-this.x, -this.y, -this.z);
    }

    public Point3D multiply(float scalar) {
        return Point3D.valueOf(this.x * scalar, this.y * scalar, this.z * scalar);
    }

    public Point3D rounded() {
        return Point3D.valueOf(Math.round(this.x), Math.round(this.y), Math.round(this.z));
    }

    public Point3D subtract(Point3D point) {
        assert (point != null);
        return Point3D.valueOf(this.x - point.x, this.y - point.y, this.z - point.z);
    }

    public Point3D toXZ() {
        return Point3D.valueOf(this.x, 0.0f, this.z);
    }

    public Point3D toXY() {
        return Point3D.valueOf(this.x, this.y, 0.0f);
    }

    public Point3D toYZ() {
        return Point3D.valueOf(0.0f, this.y, this.z);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.x);
        result = 31 * result + Float.floatToIntBits(this.y);
        result = 31 * result + Float.floatToIntBits(this.z);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Point3D)) {
            return false;
        }
        Point3D other = (Point3D)obj;
        boolean zeroX = this.x < 1.0E-5f && this.x > -1.0E-5f && other.x < 1.0E-5f && other.x > -1.0E-5f;
        boolean zeroY = this.y < 1.0E-5f && this.y > -1.0E-5f && other.y < 1.0E-5f && other.y > -1.0E-5f;
        boolean zeroZ = this.z < 1.0E-5f && this.z > -1.0E-5f && other.z < 1.0E-5f && other.z > -1.0E-5f;
        return !(!zeroX && Float.floatToIntBits(this.x) != Float.floatToIntBits(other.x) || !zeroY && Float.floatToIntBits(this.y) != Float.floatToIntBits(other.y) || !zeroZ && Float.floatToIntBits(this.z) != Float.floatToIntBits(other.z));
    }

    public String toString() {
        return this.x + "," + this.y + "," + this.z;
    }
}

