/*
 * Decompiled with CFR 0.152.
 */
package be.yildizgames.common.geometry;

public final class Point2D {
    public static final Point2D ZERO = new Point2D(0.0f, 0.0f);
    public final float x;
    public final float y;

    private Point2D(float xValue, float yValue) {
        this.x = xValue;
        this.y = yValue;
    }

    public static Point2D valueOf(float x, float y) {
        return new Point2D(x, y);
    }

    public Point2D add(float xValue, float yValue) {
        return new Point2D(this.x + xValue, this.y + yValue);
    }

    public Point2D add(Point2D point) {
        return this.add(point.x, point.y);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Point2D)) {
            return false;
        }
        Point2D other = (Point2D)obj;
        return this.x == other.x && this.y == other.y;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)this.x;
        result = 31 * result + (int)this.y;
        return result;
    }

    public Point2D multiplyByScalar(float scalar) {
        return new Point2D(this.x * scalar, this.y * scalar);
    }

    public Point2D subtract(float xValue, float yValue) {
        return new Point2D(this.x - xValue, this.y - yValue);
    }

    public Point2D subtract(Point2D point) {
        return this.subtract(point.x, point.y);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.x);
        sb.append(',');
        sb.append(this.y);
        return sb.toString();
    }
}

