/*
 * Decompiled with CFR 0.152.
 */
package be.yildizgames.common.configuration;

import be.yildizgames.common.configuration.ConfigurationReloadedBehavior;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;

public class FileReloadableConfiguration {
    private final Path path;
    private final ConfigurationReloadedBehavior behavior;

    public FileReloadableConfiguration(Path configPath, ConfigurationReloadedBehavior behavior) {
        this.path = configPath;
        this.behavior = behavior;
    }

    void inspect() {
        this.inspect(Integer.MAX_VALUE);
    }

    void inspect(int max) {
        new Thread(new Reloader(max)).start();
    }

    private class Reloader
    implements Runnable {
        private final int max;

        public Reloader(int max) {
            this.max = max;
        }

        @Override
        public void run() {
            try {
                WatchService watcher = FileSystems.getDefault().newWatchService();
                FileReloadableConfiguration.this.path.getParent().register(watcher, StandardWatchEventKinds.ENTRY_MODIFY);
                try {
                    WatchKey key;
                    for (int current = 0; current < this.max && (key = watcher.take()) != null; ++current) {
                        for (WatchEvent<?> event : key.pollEvents()) {
                            FileReloadableConfiguration.this.behavior.reload();
                        }
                        key.reset();
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

