/*
 * Decompiled with CFR 0.152.
 */
package be.yildizgames.common.configuration;

import be.yildizgames.common.configuration.ConfigurationNotFoundStrategy;
import be.yildizgames.common.configuration.ConfigurationReloadedBehavior;
import be.yildizgames.common.configuration.ConfigurationRetriever;
import be.yildizgames.common.configuration.FileReloadableConfiguration;
import be.yildizgames.common.configuration.parameter.ApplicationArgs;
import be.yildizgames.common.file.FileProperties;
import be.yildizgames.common.logging.PreLogger;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;

class FileConfigurationRetriever
implements ConfigurationRetriever {
    private final PreLogger preLogger = new PreLogger();
    private final ConfigurationNotFoundStrategy notFoundStrategy;
    private Path configPath;

    FileConfigurationRetriever(ConfigurationNotFoundStrategy strategy) {
        Objects.requireNonNull(strategy);
        this.notFoundStrategy = strategy;
    }

    @Override
    public Properties retrieveFromArgs(ApplicationArgs args) {
        this.preLogger.info("Loading configuration file...");
        Optional<String> path = args.getArg("configuration");
        if (path.isEmpty()) {
            this.preLogger.error("Configuration file not found, no application arg provider with 'configuration' key");
            return this.notFoundStrategy.notFound();
        }
        try {
            this.configPath = Paths.get(path.get(), new String[0]);
            Properties properties = FileProperties.getPropertiesFromFile((Path)this.configPath, (String[])new String[0]);
            this.preLogger.info("Loading configuration file success.");
            return properties;
        }
        catch (IllegalStateException e) {
            this.preLogger.error("Configuration file not found", (Exception)e);
            return this.notFoundStrategy.notFound();
        }
    }

    @Override
    public final void onReload(ConfigurationReloadedBehavior behavior) {
        Optional.ofNullable(this.configPath).ifPresent(path -> new FileReloadableConfiguration(this.configPath, behavior).inspect());
    }
}

