/*
 * Decompiled with CFR 0.152.
 */
package be.yildizgames.common.configuration;

import be.yildizgames.common.configuration.ConfigurationNotFoundAdditionalBehavior;
import be.yildizgames.common.configuration.ConfigurationNotFoundStrategy;
import be.yildizgames.common.logging.PreLogger;
import java.util.Objects;
import java.util.Properties;

public class ConfigurationNotFoundDefault
implements ConfigurationNotFoundStrategy {
    private final PreLogger preLogger = new PreLogger();
    private final Properties properties;

    private ConfigurationNotFoundDefault(Properties properties) {
        this.preLogger.info("Loading properties failed, fallback to default values.");
        Objects.requireNonNull(properties);
        this.properties = properties;
    }

    private ConfigurationNotFoundDefault(Properties properties, ConfigurationNotFoundAdditionalBehavior behavior) {
        this(properties);
        behavior.execute();
    }

    public static ConfigurationNotFoundStrategy fromDefault(Properties properties) {
        return new ConfigurationNotFoundDefault(properties);
    }

    public static ConfigurationNotFoundStrategy fromDefault(Properties properties, ConfigurationNotFoundAdditionalBehavior behavior) {
        return new ConfigurationNotFoundDefault(properties, behavior);
    }

    @Override
    public final Properties notFound() {
        this.preLogger.warn("Using default properties.");
        return this.properties;
    }
}

