/*
 * Decompiled with CFR 0.152.
 */
package be.yildizgames.common.configuration.parameter;

import be.yildizgames.common.configuration.parameter.Arg;
import be.yildizgames.common.logging.LogEngineProvider;
import be.yildizgames.common.logging.PreLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class ApplicationArgs {
    private final PreLogger preLogger = LogEngineProvider.getLoggerProvider().getLogEngine().getPrelogger();
    private final List<Arg> args = new ArrayList<Arg>();
    private final List<String> noKeyArgs = new ArrayList<String>();

    private ApplicationArgs(String[] args) {
        if (args == null) {
            this.preLogger.info("No args parameter passed to the application.");
        } else {
            for (String arg : args) {
                String[] value = arg.split("=");
                if (value.length == 2) {
                    this.args.add(new Arg(value[0], value[1]));
                    continue;
                }
                this.noKeyArgs.add(arg);
            }
        }
    }

    public static ApplicationArgs of(String ... args) {
        return new ApplicationArgs(args);
    }

    public final List<Arg> getArgs() {
        return Collections.unmodifiableList(this.args);
    }

    public Optional<String> getArg(String key) {
        return this.args.stream().filter(arg -> arg.key.equalsIgnoreCase(key)).map(arg -> arg.value).findFirst();
    }

    public boolean isEmpty() {
        return this.args.isEmpty();
    }
}

