/*
 * Decompiled with CFR 0.152.
 */
package be.yildizgames.common.configuration;

import be.yildizgames.common.configuration.ConfigurationNotFoundStrategy;
import be.yildizgames.common.configuration.ConfigurationRetriever;
import be.yildizgames.common.configuration.parameter.ApplicationArgs;
import be.yildizgames.common.exception.implementation.ImplementationException;
import be.yildizgames.common.file.FileProperties;
import be.yildizgames.common.file.exception.FileMissingException;
import be.yildizgames.common.logging.LogEngineProvider;
import be.yildizgames.common.logging.PreLogger;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.Properties;

class FileConfigurationRetriever
implements ConfigurationRetriever {
    private final PreLogger preLogger = LogEngineProvider.getLoggerProvider().getLogEngine().getPrelogger();
    private final ConfigurationNotFoundStrategy notFoundStrategy;

    FileConfigurationRetriever(ConfigurationNotFoundStrategy strategy) {
        ImplementationException.throwForNull((Object)strategy);
        this.notFoundStrategy = strategy;
    }

    @Override
    public Properties retrieveFromArgs(ApplicationArgs args) {
        ImplementationException.throwForNull((Object)args);
        Optional<String> path = args.getArg("configuration");
        if (path.isEmpty()) {
            this.preLogger.error("Configuration file not found, no application arg provider with 'configuration' key");
            return this.notFoundStrategy.notFound();
        }
        try {
            return FileProperties.getPropertiesFromFile((Path)Paths.get(path.get(), new String[0]), (String[])new String[0]);
        }
        catch (FileMissingException e) {
            this.preLogger.error("Configuration file not found", (Exception)((Object)e));
            return this.notFoundStrategy.notFound();
        }
    }
}

