/*
 * Decompiled with CFR 0.152.
 */
package be.yildizgames.common.client.translation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class TranslationKey {
    final String key;
    final Object[] args;

    private TranslationKey(String key) {
        this(key, new Object[0]);
    }

    private TranslationKey(String key, Object ... args) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(args);
        this.key = key;
        for (Object o : this.args = args) {
            Objects.requireNonNull(o);
        }
    }

    public static TranslationKey get(String key) {
        return new TranslationKey(key);
    }

    public static TranslationKey get(String key, Object ... args) {
        return new TranslationKey(key, args);
    }

    public static MultiKey get(TranslationKey ... keys) {
        return new MultiKey(keys);
    }

    public static MultiKey get(List<TranslationKey> keys) {
        return new MultiKey(keys);
    }

    public boolean isEmpty() {
        return "".equals(this.key);
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TranslationKey)) {
            return false;
        }
        TranslationKey key = (TranslationKey)o;
        if (!this.key.equals(key.key)) {
            return false;
        }
        return Arrays.equals(this.args, key.args);
    }

    public final int hashCode() {
        int result = this.key.hashCode();
        result = 31 * result + Arrays.hashCode(this.args);
        return result;
    }

    public static final class MultiKey {
        final List<TranslationKey> keys;

        private MultiKey(TranslationKey ... keys) {
            this.keys = new ArrayList<TranslationKey>();
            for (TranslationKey k : keys) {
                this.add(k);
            }
        }

        private MultiKey(List<TranslationKey> l) {
            Objects.requireNonNull(l);
            this.keys = new ArrayList<TranslationKey>();
            for (TranslationKey k : l) {
                this.add(k);
            }
        }

        public final void add(TranslationKey key) {
            if (!key.isEmpty()) {
                this.keys.add(key);
            }
        }
    }
}

