/*
 * Decompiled with CFR 0.152.
 */
package be.yildizgames.common.client.translation;

import be.yildizgames.common.client.translation.LanguageProvider;
import be.yildizgames.common.client.translation.TranslationKey;
import be.yildizgames.common.util.StringUtil;
import be.yildizgames.common.util.language.Language;
import be.yildizgames.common.util.language.LanguageValue;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;

public final class Translation {
    private static final Translation INSTANCE = new Translation();
    private final Map<Language, Properties> languages = new HashMap<Language, Properties>();
    private Language chosenLanguage = LanguageValue.EN;

    private Translation() {
    }

    public static Translation getInstance() {
        return INSTANCE;
    }

    public final Translation addLanguage(Language language, LanguageProvider provider) {
        Objects.requireNonNull(language);
        Objects.requireNonNull(provider);
        this.languages.put(language, provider.get(language));
        return this;
    }

    public final Translation chooseLanguage(Language language) {
        Objects.requireNonNull(language);
        if (!this.languages.containsKey(language)) {
            throw new IllegalArgumentException("Unexisting language:" + language);
        }
        this.chosenLanguage = language;
        return this;
    }

    private String get(String key) {
        if (key.isEmpty()) {
            return "";
        }
        String s = this.languages.get(this.chosenLanguage).getProperty(key);
        Objects.requireNonNull(s);
        return s;
    }

    public final String translate(TranslationKey.MultiKey keys) {
        StringBuilder sb = new StringBuilder();
        for (TranslationKey k : keys.keys) {
            sb.append(this.translate(k));
        }
        return sb.toString();
    }

    public final String translate(TranslationKey key) {
        return StringUtil.fillVariable((String)this.get(key.key), (Object[])key.args);
    }

    public final String translate(TranslationKey key, String ... args) {
        return StringUtil.fillVariable((String)this.get(key.key), (Object[])args);
    }
}

