/*
 * Decompiled with CFR 0.152.
 */
package be.yildizgames.common.client.translation;

import be.yildizgames.common.client.translation.TranslatedValue;
import be.yildizgames.common.client.translation.TranslatedValueProvider;
import be.yildizgames.common.client.translation.TranslatedValuesProvider;
import be.yildizgames.common.util.language.Language;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;

public class LanguageProvider {
    private final Map<Language, Properties> languages = new HashMap<Language, Properties>();

    public final void registerLanguage(Language l) {
        Objects.requireNonNull(l);
        this.languages.put(l, new Properties());
    }

    public final void add(String key, Language language, String value) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(language);
        Objects.requireNonNull(value);
        this.get(language).put(key, value);
    }

    public final void add(TranslatedValueProvider provider) {
        this.add(provider.getTranslatedValue());
    }

    public final void add(TranslatedValue value) {
        this.add(value.getKey(), value.getLanguage(), value.getValue());
    }

    public final void add(TranslatedValuesProvider provider) {
        for (TranslatedValueProvider t : provider) {
            this.add(t.getTranslatedValue());
        }
    }

    public final Properties get(Language language) {
        Objects.requireNonNull(language);
        Properties p = this.languages.get(language);
        Objects.requireNonNull(p);
        return p;
    }
}

