/*
 * Decompiled with CFR 0.152.
 */
package be.yildizgames.common.client.config;

import be.yildizgames.common.util.language.Language;
import be.yildizgames.common.util.language.LanguageValue;
import java.io.File;
import java.util.Objects;
import java.util.Properties;

public final class Configuration {
    private static final Configuration INSTANCE = new Configuration();
    public static final String LANGUAGE_KEY = "language";
    public static final String SAVE_CREDENTIALS_KEY = "save";
    public static final String LOGIN_KEY = "user_login";
    public static final String PWD_KEY = "user_password";
    public static final String AUTHENTICATION_HOST_KEY = "authentication_host";
    public static final String AUTHENTICATION_PORT_KEY = "authentication_port";
    public static final String SERVER_HOST_KEY = "server_host";
    public static final String SERVER_PORT_KEY = "server_port";
    public static final String DEBUG_KEY = "debug";
    private Properties properties = new Properties();
    private File filePath = new File("config.properties");

    private Configuration() {
    }

    public static Configuration getInstance() {
        return INSTANCE;
    }

    public Configuration readFromProperties(Properties p) {
        this.properties = p;
        return this;
    }

    public String getLogin() {
        return this.properties.getProperty(LOGIN_KEY, "");
    }

    public Configuration setLogin(String value) {
        Objects.requireNonNull(value);
        this.properties.setProperty(LOGIN_KEY, value);
        return this;
    }

    public String getPassword() {
        return this.properties.getProperty(PWD_KEY, "");
    }

    public Configuration setPassword(String value) {
        Objects.requireNonNull(value);
        this.properties.setProperty(PWD_KEY, value);
        return this;
    }

    public boolean isSaveCredentialsChecked() {
        return Boolean.parseBoolean(this.properties.getProperty(SAVE_CREDENTIALS_KEY));
    }

    public Configuration setSaveCredentialsChecked(boolean checked) {
        this.properties.setProperty(SAVE_CREDENTIALS_KEY, String.valueOf(checked));
        return this;
    }

    public void swapSaveCredentialsChecked() {
        this.setSaveCredentialsChecked(!this.isSaveCredentialsChecked());
    }

    public Language getLanguage() {
        String value = this.properties.getProperty(LANGUAGE_KEY, LanguageValue.EN.shortName);
        return LanguageValue.fromShortName((String)value);
    }

    public Configuration setLanguage(Language language) {
        Objects.requireNonNull(language);
        this.properties.setProperty(LANGUAGE_KEY, language.getShortName());
        return this;
    }

    boolean isLanguagePresent() {
        return this.properties.getProperty(LANGUAGE_KEY) != null;
    }

    public boolean isDebug() {
        String p = this.properties.getProperty(DEBUG_KEY);
        return p != null && p.equalsIgnoreCase("true");
    }

    public String getAuthenticationHost() {
        return this.properties.getProperty(AUTHENTICATION_HOST_KEY, "localhost");
    }

    public Configuration setAuthenticationHost(String value) {
        Objects.requireNonNull(value);
        this.properties.setProperty(AUTHENTICATION_HOST_KEY, value);
        return this;
    }

    public int getAuthenticationPort() {
        return Integer.valueOf(this.properties.getProperty(AUTHENTICATION_PORT_KEY, "15023"));
    }

    public Configuration setAuthenticationPort(int value) {
        this.properties.setProperty(AUTHENTICATION_PORT_KEY, String.valueOf(value));
        return this;
    }

    public String getServerHost() {
        return this.properties.getProperty(SERVER_HOST_KEY, "localhost");
    }

    public Configuration setServerHost(String value) {
        Objects.requireNonNull(value);
        this.properties.setProperty(SERVER_HOST_KEY, value);
        return this;
    }

    public int getServerPort() {
        return Integer.valueOf(this.properties.getProperty(SERVER_PORT_KEY, "11139"));
    }

    public Configuration setServerPort(int value) {
        this.properties.setProperty(SERVER_PORT_KEY, String.valueOf(value));
        return this;
    }
}

