/*
 * Decompiled with CFR 0.152.
 */
package be.yildizgames.common.client.translation;

import be.yildizgames.common.client.translation.LanguageProvider;
import be.yildizgames.common.client.translation.TranslationKey;
import be.yildizgames.common.exception.implementation.ImplementationException;
import be.yildizgames.common.util.StringUtil;
import be.yildizgames.common.util.language.Language;
import be.yildizgames.common.util.language.LanguageValue;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public final class Translation {
    private static final Translation INSTANCE = new Translation();
    private final Map<Language, Properties> languages = new HashMap<Language, Properties>();
    private Language chosenLanguage = LanguageValue.EN;

    private Translation() {
    }

    public static Translation getInstance() {
        return INSTANCE;
    }

    public Translation addLanguage(Language language, LanguageProvider provider) {
        ImplementationException.throwForNull((Object)language);
        ImplementationException.throwForNull((Object)provider);
        this.languages.put(language, provider.get(language));
        this.languages.values().forEach(ImplementationException::throwForNull);
        return this;
    }

    public Translation chooseLanguage(Language language) {
        ImplementationException.throwForNull((Object)language);
        if (!this.languages.containsKey(language)) {
            throw new IllegalArgumentException("Unexisting language:" + language);
        }
        this.chosenLanguage = language;
        return this;
    }

    private String get(String key) {
        if (key.isEmpty()) {
            return "";
        }
        String s = this.languages.get(this.chosenLanguage).getProperty(key);
        ImplementationException.throwForNull((Object)s);
        return s;
    }

    public String translate(TranslationKey.MultiKey keys) {
        StringBuilder sb = new StringBuilder();
        for (TranslationKey k : keys.keys) {
            sb.append(this.translate(k));
        }
        return sb.toString();
    }

    public String translate(TranslationKey key) {
        return StringUtil.fillVariable((String)this.get(key.key), (Object[])key.args);
    }

    public String translate(TranslationKey key, String ... args) {
        return StringUtil.fillVariable((String)this.get(key.key), (Object[])args);
    }
}

