/*
 * Decompiled with CFR 0.152.
 */
package be.yildizgames.common.client.translation;

import be.yildizgames.common.client.translation.TranslatedValue;
import be.yildizgames.common.client.translation.TranslatedValueProvider;
import be.yildizgames.common.client.translation.TranslatedValuesProvider;
import be.yildizgames.common.exception.implementation.ImplementationException;
import be.yildizgames.common.util.language.Language;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class LanguageProvider {
    private final Map<Language, Properties> languages = new HashMap<Language, Properties>();

    public final void registerLanguage(Language l) {
        ImplementationException.throwForNull((Object)l);
        this.languages.put(l, new Properties());
    }

    public final void add(String key, Language language, String value) {
        ImplementationException.throwForNull((Object)key);
        ImplementationException.throwForNull((Object)language);
        ImplementationException.throwForNull((Object)value);
        this.get(language).put(key, value);
    }

    public final void add(TranslatedValueProvider provider) {
        ImplementationException.throwForNull((Object)provider);
        this.add(provider.getTranslatedValue());
    }

    public final void add(TranslatedValue value) {
        ImplementationException.throwForNull((Object)value);
        this.add(value.getKey(), value.getLanguage(), value.getValue());
    }

    public void add(TranslatedValuesProvider provider) {
        ImplementationException.throwForNull((Object)provider);
        for (TranslatedValueProvider t : provider) {
            this.add(t.getTranslatedValue());
        }
    }

    public Properties get(Language language) {
        ImplementationException.throwForNull((Object)language);
        Properties p = this.languages.get(language);
        ImplementationException.throwForNull((Object)p);
        return p;
    }
}

