/*
 * Decompiled with CFR 0.152.
 */
package be.yildizgames.common.application;

import be.yildizgames.common.logging.Logger;
import java.io.File;

public class SystemRestarter {
    private final Logger logger = Logger.getLogger((Object)this);
    private final String app;
    private final String javaPath;

    public SystemRestarter(String jarName) {
        this.app = jarName;
        this.javaPath = System.getProperty("java.home") + File.separator + "bin" + File.separator;
    }

    public SystemRestarter(String jarName, String javaPath) {
        this.app = jarName;
        this.javaPath = javaPath.endsWith(File.separator) ? javaPath : javaPath + File.separator;
    }

    public void restartApplication(long msBeforeRestart) {
        try {
            this.logger.info("Restarting the system.");
            StringBuilder cmd = new StringBuilder();
            cmd.append(this.javaPath).append("java ").append("-jar ").append(this.app);
            Thread.sleep(msBeforeRestart);
            Runtime.getRuntime().exec(cmd.toString());
            System.exit(0);
        }
        catch (Exception e) {
            throw new IllegalStateException("The application could not restart", e);
        }
    }
}

