/*
 * Decompiled with CFR 0.152.
 */
package be.yildizgames.common.application.helper.updater;

import be.yildizgames.common.application.helper.updater.UpdateDownloadListener;
import be.yildizgames.common.logging.Logger;
import be.yildizgames.module.http.HttpRequest;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.temporal.TemporalAmount;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.update4j.Archive;
import org.update4j.Configuration;
import org.update4j.FileMetadata;
import org.update4j.UpdateOptions;
import org.update4j.service.UpdateHandler;

public class UpdateHelper {
    private final Map<String, LocalDateTime> lastUpdate = new HashMap<String, LocalDateTime>();

    public void update(String url, String archiveName, TemporalAmount delay, List<UpdateDownloadListener> listener) {
        LocalDateTime now = LocalDateTime.now();
        if (!this.lastUpdate.containsKey(url) || now.isAfter(this.lastUpdate.computeIfAbsent(url, a -> now).plus(delay))) {
            try {
                Configuration config = Configuration.read((Reader)new HttpRequest().getReader(url));
                if (config.requiresUpdate()) {
                    config.update((UpdateOptions.ArchiveUpdateOptions)UpdateOptions.archive((Path)Path.of(archiveName, new String[0])).updateHandler((UpdateHandler)new UpdateHandlerNotifier(listener)));
                    Archive.read((String)archiveName).install(true);
                }
                this.lastUpdate.put(url, now);
            }
            catch (IOException e) {
                Logger.getLogger((Object)this).error((Throwable)e);
            }
        }
    }

    private static class UpdateHandlerNotifier
    implements UpdateHandler {
        private final List<UpdateDownloadListener> listener;

        private UpdateHandlerNotifier(List<UpdateDownloadListener> listener) {
            this.listener = listener;
        }

        public final void startDownloads() {
            this.listener.forEach(UpdateDownloadListener::startDownloads);
        }

        public final void updateDownloadFileProgress(FileMetadata file, float frac) {
            this.listener.forEach(l -> l.fileUpdated(file.getPath(), (int)(frac * 100.0f)));
        }

        public final void doneDownloadFile(FileMetadata file, Path path) {
            this.listener.forEach(l -> l.fileCompletedSuccessfully(file.getPath()));
        }

        public final void updateDownloadProgress(float frac) {
            this.listener.forEach(l -> l.downloadUpdated((int)(frac * 100.0f)));
        }

        public final void doneDownloads() {
            this.listener.forEach(UpdateDownloadListener::downloadCompletedSuccessfully);
        }

        public final void startDownloadFile(FileMetadata file) {
            this.listener.forEach(l -> l.startDownloadFile(file.getPath()));
        }

        public final void succeeded() {
            this.listener.forEach(UpdateDownloadListener::completed);
        }
    }
}

