/*
 * Decompiled with CFR 0.152.
 */
package be.yildizgames.common.application.helper.network;

import be.yildizgames.common.application.helper.network.AvailabilityChecker;
import be.yildizgames.common.application.helper.network.ServerAccessConfiguration;
import be.yildizgames.common.application.helper.network.SocketPingCheck;

public class SocketAvailabilityChecker
implements AvailabilityChecker {
    private static final long DELAY = 60000L;
    private long lastCheck = 0L;
    private AvailabilityStatus current;
    private final SocketPingCheck checker;

    public SocketAvailabilityChecker(ServerAccessConfiguration configuration) {
        this.checker = new SocketPingCheck(configuration);
    }

    private AvailabilityStatus respond() {
        if (this.current == AvailabilityStatus.CHECKING) {
            return this.current;
        }
        long now = System.currentTimeMillis();
        if (now - this.lastCheck < 60000L) {
            return this.current;
        }
        this.current = AvailabilityStatus.CHECKING;
        this.current = this.checker.respond() ? AvailabilityStatus.ONLINE : AvailabilityStatus.OFFLINE;
        this.lastCheck = now;
        return this.current;
    }

    @Override
    public boolean isOnline() {
        return this.respond().equals((Object)AvailabilityStatus.ONLINE);
    }

    public boolean isChecking() {
        return this.respond().equals((Object)AvailabilityStatus.CHECKING);
    }

    public final boolean isOffLine() {
        return this.respond().equals((Object)AvailabilityStatus.OFFLINE);
    }

    private static enum AvailabilityStatus {
        CHECKING,
        ONLINE,
        OFFLINE;

    }
}

