/*
 * Decompiled with CFR 0.152.
 */
package be.yildizgames.common.application;

import be.yildizgames.common.application.Starter;
import be.yildizgames.common.application.helper.cli.Banner;
import be.yildizgames.common.application.helper.cli.BannerLine;
import be.yildizgames.common.application.helper.logging.LoggerPropertiesConsoleFile;
import be.yildizgames.common.application.helper.splashscreen.EmptySplashScreen;
import be.yildizgames.common.application.helper.splashscreen.SplashScreen;
import be.yildizgames.common.application.helper.splashscreen.SplashScreenProvider;
import be.yildizgames.common.configuration.ConfigurationNotFoundAdditionalBehavior;
import be.yildizgames.common.configuration.ConfigurationNotFoundDefault;
import be.yildizgames.common.configuration.ConfigurationNotFoundStrategy;
import be.yildizgames.common.configuration.ConfigurationRetriever;
import be.yildizgames.common.configuration.ConfigurationRetrieverFactory;
import be.yildizgames.common.configuration.parameter.ApplicationArgs;
import be.yildizgames.common.git.GitProperties;
import be.yildizgames.common.git.GitPropertiesProvider;
import be.yildizgames.common.logging.LogEngine;
import be.yildizgames.common.logging.LogEngineProvider;
import be.yildizgames.common.logging.LoggerPropertiesConfiguration;
import be.yildizgames.module.http.HttpRequest;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.update4j.Configuration;

public class Application {
    private final String applicationName;
    private String updateUrl;
    private int updateTimeOut = -1;
    private Properties properties = new Properties();
    private boolean started;
    private Banner banner;
    private SplashScreenProvider splashScreenProvider = EmptySplashScreen::new;
    private SplashScreen splashScreen;

    private Application(String applicationName) {
        Application.shutThirdPartyLogger();
        this.applicationName = Objects.requireNonNull(applicationName);
        this.banner = new Banner(applicationName);
        if (applicationName.isEmpty()) {
            throw new IllegalArgumentException("Application name cannot be empty");
        }
    }

    private static void shutThirdPartyLogger() {
        Logger databaseLogger = Logger.getLogger("hsqldb.db");
        databaseLogger.setUseParentHandlers(false);
        databaseLogger.setLevel(Level.WARNING);
    }

    public static Application prepare(String applicationName) {
        return new Application(applicationName);
    }

    public final Application withConfiguration(String[] args, Properties defaultConfig, ConfigurationNotFoundAdditionalBehavior behavior) {
        ConfigurationRetriever configurationRetriever = ConfigurationRetrieverFactory.fromFile((ConfigurationNotFoundStrategy)ConfigurationNotFoundDefault.fromDefault((Properties)Stream.of(new LoggerPropertiesConsoleFile(this.applicationName), defaultConfig).collect(Properties::new, Map::putAll, Map::putAll), (ConfigurationNotFoundAdditionalBehavior)behavior));
        this.properties = configurationRetriever.retrieveFromArgs(ApplicationArgs.of((String[])args));
        return this;
    }

    public final Application withBanner(Banner banner) {
        this.banner = Objects.requireNonNull(banner);
        return this;
    }

    public final Application withSplashScreen(SplashScreenProvider splashScreen) {
        this.splashScreenProvider = Objects.requireNonNull(splashScreen);
        return this;
    }

    public final Application addBannerLine(BannerLine line) {
        this.banner.addLine(line);
        return this;
    }

    public final Application withConfiguration(String[] args, Properties defaultConfig) {
        return this.withConfiguration(args, defaultConfig, () -> {});
    }

    public final Application withUpdate(String url) {
        this.updateUrl = Objects.requireNonNull(url);
        return this;
    }

    public final Application withUpdate(String url, int timeout) {
        this.updateUrl = Objects.requireNonNull(url);
        this.updateTimeOut = timeout;
        return this;
    }

    public final Application start() {
        if (this.started) {
            return this;
        }
        try {
            this.init();
            this.started = true;
            return this;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public final Application start(Starter starter) {
        if (this.started) {
            return this;
        }
        try {
            this.init();
            starter.setApplication(this);
            starter.startLoggedErrors();
            this.started = true;
            this.applicationStarted();
            return this;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public final void applicationStarted() {
        this.splashScreen.close();
    }

    public final Properties getConfiguration() {
        return this.properties;
    }

    private void init() throws IOException {
        LogEngine logEngine = LogEngineProvider.getLoggerProvider().getLogEngine();
        logEngine.configureFromProperties(LoggerPropertiesConfiguration.fromProperties((Properties)this.properties));
        System.Logger logger = System.getLogger(Application.class.getName());
        this.banner.display();
        logger.log(System.Logger.Level.INFO, "Starting {0} (PID:{1}).", this.applicationName, ProcessHandle.current().pid());
        GitProperties git = GitPropertiesProvider.getGitProperties();
        logger.log(System.Logger.Level.INFO, "Commit: {0}", git.getCommitId());
        logger.log(System.Logger.Level.INFO, "Built at {0}", git.getBuildTime());
        this.splashScreen = this.splashScreenProvider.buildSplashScreen();
        this.splashScreen.setName(this.applicationName);
        this.splashScreen.display();
        Optional.ofNullable(this.updateUrl).ifPresent(this::update);
    }

    private void update(String url) {
        try {
            Configuration.read((Reader)new HttpRequest(this.updateTimeOut).getReader(url)).update();
        }
        catch (Exception e) {
            be.yildizgames.common.logging.Logger.getLogger(Application.class).error((Throwable)e);
        }
    }
}

