/*
 * Decompiled with CFR 0.152.
 */
package be.yildizgames.common.application;

import be.yildizgames.common.application.Starter;
import be.yildizgames.common.configuration.ConfigurationNotFoundAdditionalBehavior;
import be.yildizgames.common.configuration.ConfigurationNotFoundDefault;
import be.yildizgames.common.configuration.ConfigurationNotFoundStrategy;
import be.yildizgames.common.configuration.ConfigurationRetriever;
import be.yildizgames.common.configuration.ConfigurationRetrieverFactory;
import be.yildizgames.common.configuration.parameter.ApplicationArgs;
import be.yildizgames.common.git.GitProperties;
import be.yildizgames.common.git.GitPropertiesProvider;
import be.yildizgames.common.logging.LogEngine;
import be.yildizgames.common.logging.LogEngineProvider;
import be.yildizgames.common.logging.LoggerPropertiesConfiguration;
import java.io.IOException;
import java.util.Properties;

public class Application {
    private final String applicationName;
    private Properties properties = new Properties();
    private boolean started;

    private Application(String applicationName) {
        this.applicationName = applicationName;
    }

    public static Application prepare(String applicationName) {
        return new Application(applicationName);
    }

    public Application withConfiguration(String[] args, Properties defaultConfig, ConfigurationNotFoundAdditionalBehavior behavior) {
        ConfigurationRetriever configurationRetriever = ConfigurationRetrieverFactory.fromFile((ConfigurationNotFoundStrategy)ConfigurationNotFoundDefault.fromDefault((Properties)defaultConfig, (ConfigurationNotFoundAdditionalBehavior)behavior));
        this.properties = configurationRetriever.retrieveFromArgs(ApplicationArgs.of((String[])args));
        return this;
    }

    public Application withConfiguration(String[] args, Properties defaultConfig) {
        return this.withConfiguration(args, defaultConfig, () -> {});
    }

    public Application start() {
        if (this.started) {
            return this;
        }
        try {
            this.init();
            this.started = true;
            return this;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public Application start(Starter starter) {
        if (this.started) {
            return this;
        }
        try {
            this.init();
            starter.setApplication(this);
            starter.start();
            this.started = true;
            return this;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private void init() throws IOException {
        LogEngine logEngine = LogEngineProvider.getLoggerProvider().getLogEngine();
        logEngine.configureFromProperties(LoggerPropertiesConfiguration.fromProperties((Properties)this.properties));
        System.Logger logger = System.getLogger(Application.class.getName());
        logger.log(System.Logger.Level.INFO, "Starting {0} (PID:{1}).", this.applicationName, ProcessHandle.current().pid());
        GitProperties git = GitPropertiesProvider.getGitProperties();
        logger.log(System.Logger.Level.INFO, "Commit: {0}", git.getCommitId());
        logger.log(System.Logger.Level.INFO, "Built at {0}", git.getBuildTime());
    }

    public final Properties getConfiguration() {
        return this.properties;
    }
}

