/*
 * Decompiled with CFR 0.152.
 */
package be.yildizgames.common.application;

import be.yildizgames.common.application.Starter;
import be.yildizgames.common.application.helper.cli.Banner;
import be.yildizgames.common.application.helper.cli.BannerLine;
import be.yildizgames.common.configuration.ConfigurationNotFoundAdditionalBehavior;
import be.yildizgames.common.configuration.ConfigurationNotFoundDefault;
import be.yildizgames.common.configuration.ConfigurationNotFoundStrategy;
import be.yildizgames.common.configuration.ConfigurationRetriever;
import be.yildizgames.common.configuration.ConfigurationRetrieverFactory;
import be.yildizgames.common.configuration.parameter.ApplicationArgs;
import be.yildizgames.common.git.GitProperties;
import be.yildizgames.common.git.GitPropertiesProvider;
import be.yildizgames.common.logging.LogEngine;
import be.yildizgames.common.logging.LogEngineProvider;
import be.yildizgames.common.logging.Logger;
import be.yildizgames.common.logging.LoggerPropertiesConfiguration;
import be.yildizgames.module.http.HttpRequest;
import java.io.IOException;
import java.io.Reader;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.update4j.Configuration;

public class Application {
    private final String applicationName;
    private String updateUrl;
    private Properties properties = new Properties();
    private boolean started;
    private Banner banner;

    private Application(String applicationName) {
        this.applicationName = Objects.requireNonNull(applicationName);
        this.banner = new Banner(applicationName);
        if (applicationName.isEmpty()) {
            throw new IllegalArgumentException("Application name cannot be empty");
        }
    }

    public static Application prepare(String applicationName) {
        return new Application(applicationName);
    }

    public final Application withConfiguration(String[] args, Properties defaultConfig, ConfigurationNotFoundAdditionalBehavior behavior) {
        ConfigurationRetriever configurationRetriever = ConfigurationRetrieverFactory.fromFile((ConfigurationNotFoundStrategy)ConfigurationNotFoundDefault.fromDefault((Properties)defaultConfig, (ConfigurationNotFoundAdditionalBehavior)behavior));
        this.properties = configurationRetriever.retrieveFromArgs(ApplicationArgs.of((String[])args));
        return this;
    }

    public final Application withBanner(Banner banner) {
        this.banner = Objects.requireNonNull(banner);
        return this;
    }

    public final Application addBannerLine(BannerLine line) {
        this.banner.addLine(line);
        return this;
    }

    public final Application withConfiguration(String[] args, Properties defaultConfig) {
        return this.withConfiguration(args, defaultConfig, () -> {});
    }

    public final Application withUpdate(String url) {
        this.updateUrl = url;
        return this;
    }

    public final Application start() {
        if (this.started) {
            return this;
        }
        try {
            this.init();
            this.started = true;
            return this;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public final Application start(Starter starter) {
        if (this.started) {
            return this;
        }
        try {
            this.init();
            starter.setApplication(this);
            starter.start();
            this.started = true;
            return this;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public final Properties getConfiguration() {
        return this.properties;
    }

    private void init() throws IOException {
        LogEngine logEngine = LogEngineProvider.getLoggerProvider().getLogEngine();
        logEngine.configureFromProperties(LoggerPropertiesConfiguration.fromProperties((Properties)this.properties));
        System.Logger logger = System.getLogger(Application.class.getName());
        this.banner.display();
        logger.log(System.Logger.Level.INFO, "Starting {0} (PID:{1}).", this.applicationName, ProcessHandle.current().pid());
        GitProperties git = GitPropertiesProvider.getGitProperties();
        logger.log(System.Logger.Level.INFO, "Commit: {0}", git.getCommitId());
        logger.log(System.Logger.Level.INFO, "Built at {0}", git.getBuildTime());
        Optional.ofNullable(this.updateUrl).ifPresent(this::update);
    }

    private void update(String url) {
        try {
            Configuration.read((Reader)new HttpRequest().getReader(url)).update();
        }
        catch (Exception e) {
            Logger.getLogger(Application.class).error((Throwable)e);
        }
    }
}

